/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.waters;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.ComplexEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.waters.WaterType;
import org.slf4j.Logger;

public abstract class ComplexWaterEntity
extends ComplexEntity {
    private static final long serialVersionUID = 7835788819725148174L;
    private final WaterType waterType;

    public ComplexWaterEntity(AtlasEntity source, WaterType waterType) {
        super(source);
        this.waterType = waterType;
        try {
            this.populateGeometry();
        }
        catch (Exception e) {
            this.getLogger().warn("Unable to create complex water entity from {}", (Object)source, (Object)e);
            this.setInvalidReason("Unable to create complex water entity", e);
            return;
        }
    }

    @Override
    public List<ComplexEntity.ComplexEntityError> getAllInvalidations() {
        ArrayList<ComplexEntity.ComplexEntityError> returnValue = new ArrayList<ComplexEntity.ComplexEntityError>();
        if (!this.isValid()) {
            returnValue.add(this.getError().get());
        }
        return returnValue;
    }

    public WaterType getWaterType() {
        return this.waterType;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " " + (Object)((Object)this.getWaterType()) + " " + this.getSource();
    }

    protected abstract Logger getLogger();

    protected abstract void populateGeometry();
}

