/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.highwayarea;

import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Route;

class ComplexHighwayAreaHelper {
    private final NavigableSet<Long> visitedEdgeIdentifiers = new TreeSet<Long>();
    private PolyLine boundary;
    private Edge sourceEdge;
    private CoreException oops;

    ComplexHighwayAreaHelper(Edge edge) {
        this.sourceEdge = edge;
        this.buildHighwayAreaBoundary(Route.forEdge(edge)).ifPresent(route -> {
            this.boundary = route.asPolyLine();
            StreamSupport.stream(route.spliterator(), false).map(AtlasObject::getIdentifier).forEach(this.visitedEdgeIdentifiers::add);
            this.sourceEdge = edge.getAtlas().edge((Long)this.visitedEdgeIdentifiers.first());
        });
        if (this.boundary == null) {
            this.oops = new CoreException("Unable to build boundary for edge {}", edge.getOsmIdentifier());
        }
    }

    PolyLine getBoundary() {
        return this.boundary;
    }

    CoreException getException() {
        return this.oops;
    }

    Edge getSourceEdge() {
        return this.sourceEdge;
    }

    NavigableSet<Long> getVisitedEdgeIdentifiers() {
        return this.visitedEdgeIdentifiers;
    }

    private Optional<Route> buildHighwayAreaBoundary(Route boundary) {
        for (Edge edge : boundary.end().end().connectedEdges()) {
            if (!this.canAddEdgeToBoundary(edge, boundary)) continue;
            Route extendedBoundary = boundary.append(edge);
            if (extendedBoundary.end().end().getLocation().equals(extendedBoundary.start().start().getLocation())) {
                return Optional.of(extendedBoundary);
            }
            return this.buildHighwayAreaBoundary(extendedBoundary);
        }
        return Optional.empty();
    }

    private boolean canAddEdgeToBoundary(Edge edge, Route boundary) {
        return edge.getIdentifier() != -boundary.end().getIdentifier() && edge.getOsmIdentifier() == boundary.end().getOsmIdentifier() && boundary.end().end().getLocation().equals(edge.start().getLocation()) && !boundary.includes(edge);
    }
}

