/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.highwayarea;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.complex.ComplexEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.highwayarea.ComplexHighwayAreaHelper;
import org.openstreetmap.atlas.utilities.scalars.Surface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexHighwayArea
extends ComplexEntity {
    private static final long serialVersionUID = 441824709133762710L;
    private static final Logger logger = LoggerFactory.getLogger(ComplexHighwayArea.class);
    private PolyLine boundary;
    private final NavigableSet<Long> visitedEdgeIdentifiers = new TreeSet<Long>();

    protected ComplexHighwayArea(ComplexHighwayAreaHelper helper) {
        super(helper.getSourceEdge());
        try {
            if (helper.getException() != null) {
                throw helper.getException();
            }
            this.boundary = helper.getBoundary();
            this.visitedEdgeIdentifiers.addAll(helper.getVisitedEdgeIdentifiers());
            if (this.isSelfIntersecting()) {
                throw new CoreException("Self-intersecting geometry");
            }
            if (this.isZeroSized()) {
                throw new CoreException("Zero-sized area");
            }
        }
        catch (Exception oops) {
            logger.warn("Unable to create ComplexHighwayArea from {}", (Object)helper.getSourceEdge(), (Object)oops);
            this.setInvalidReason("Couldn't create ComplexHighwayArea", oops);
        }
    }

    protected ComplexHighwayArea(Edge edge) {
        this(new ComplexHighwayAreaHelper(edge));
    }

    @Override
    public List<ComplexEntity.ComplexEntityError> getAllInvalidations() {
        ArrayList<ComplexEntity.ComplexEntityError> returnValue = new ArrayList<ComplexEntity.ComplexEntityError>();
        if (!this.isValid()) {
            returnValue.add(this.getError().get());
        }
        return returnValue;
    }

    public PolyLine getHighwayAreaBoundary() {
        return this.boundary;
    }

    public NavigableSet<Long> getVisitedEdgeIdentifiers() {
        return this.visitedEdgeIdentifiers;
    }

    public boolean isSelfIntersecting() {
        return this.boundaryAsPolygon().selfIntersects();
    }

    public boolean isZeroSized() {
        return this.boundaryAsPolygon().surface().equals(Surface.MINIMUM);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("osm", this.getSource().getOsmIdentifier()).add("atlas", this.getSource().getIdentifier()).add("boundary", this.boundary).toString();
    }

    private Polygon boundaryAsPolygon() {
        if (!this.isValid()) {
            throw new CoreException("Highway Area is invalid {}", this.getOsmIdentifier());
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.addAll(this.boundary);
        return new Polygon((List<Location>)locations);
    }
}

