/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.buildings;

import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.complex.Finder;
import org.openstreetmap.atlas.geography.atlas.items.complex.buildings.ComplexBuilding;
import org.openstreetmap.atlas.tags.BuildingTag;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;

public class ComplexBuildingFinder
implements Finder<ComplexBuilding> {
    @Override
    public Iterable<ComplexBuilding> find(Atlas atlas) {
        Iterable<Area> simpleBuildings = atlas.areas(area -> this.isBuilding((Area)area) && this.isSimple((AtlasEntity)area));
        Iterable<ComplexBuilding> simpleEntities = Iterables.translate(simpleBuildings, ComplexBuilding::new);
        Iterable<Relation> complexBuildings = atlas.relations(relation -> this.isBuilding((Relation)relation) && this.isSimple((AtlasEntity)relation));
        Iterable<ComplexBuilding> complexEntities = Iterables.translate(complexBuildings, ComplexBuilding::new);
        return new MultiIterable<ComplexBuilding>(simpleEntities, complexEntities);
    }

    private boolean hasChildAreaAsBuilding(Relation relation) {
        for (RelationMember member : relation.members()) {
            AtlasEntity entity = member.getEntity();
            String role = member.getRole();
            if (!(entity instanceof Area) || !"outer".equals(role) || !this.isBuilding((Area)entity)) continue;
            return true;
        }
        return false;
    }

    private boolean isBuilding(Area area) {
        return BuildingTag.isBuilding(area);
    }

    private boolean isBuilding(Relation relation) {
        String type = relation.tag("type");
        return "building".equals(type) || "multipolygon".equals(type) && (BuildingTag.isBuilding(relation) || this.hasChildAreaAsBuilding(relation));
    }

    private boolean isSimple(AtlasEntity entity) {
        for (Relation relation : entity.relations()) {
            if (!this.isBuilding(relation)) continue;
            return false;
        }
        return true;
    }
}

