/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex.buildings;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.ComplexEntity;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationOrAreaToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.atlas.items.complex.buildings.HeightConverter;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildingPart
extends ComplexEntity {
    private static final long serialVersionUID = 364620404649236692L;
    private static final Logger logger = LoggerFactory.getLogger(BuildingPart.class);
    private static final RelationOrAreaToMultiPolygonConverter BUILDING_OUTLINE_CONVERTER = new RelationOrAreaToMultiPolygonConverter();
    private static final HeightConverter HEIGHT_CONVERTER = new HeightConverter();
    private MultiPolygon geometry;

    public BuildingPart(AtlasEntity source) {
        super(source);
        try {
            this.geometry = BUILDING_OUTLINE_CONVERTER.convert(source);
        }
        catch (Exception e) {
            logger.warn("Unable to create building part from {}", (Object)source, (Object)e);
            this.setInvalidReason("Unable to create building part", e);
            return;
        }
    }

    @Override
    public List<ComplexEntity.ComplexEntityError> getAllInvalidations() {
        ArrayList<ComplexEntity.ComplexEntityError> returnValue = new ArrayList<ComplexEntity.ComplexEntityError>();
        if (!this.isValid()) {
            returnValue.add(this.getError().get());
        }
        return returnValue;
    }

    public MultiPolygon getGeometry() {
        return this.geometry;
    }

    public Optional<Distance> topHeight() {
        Map<String, String> tags = this.getSource().getTags();
        String heightTag = tags.get("height");
        try {
            if (heightTag != null) {
                return Optional.of(HEIGHT_CONVERTER.convert(heightTag));
            }
        }
        catch (Exception e) {
            logger.warn("Invalid height {} for building part id {}", (Object)heightTag, (Object)this.getSource().getIdentifier());
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return "[BuildingPart: Geometry = " + this.geometry.toReadableString() + "]";
    }
}

