/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.converters.MultiplePolyLineToPolygonsConverter;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.conversion.Converter;

public class RelationToMultiPolygonMemberConverter
implements Converter<Relation, Iterable<Polygon>> {
    private static final MultiplePolyLineToPolygonsConverter MULTIPLE_POLY_LINE_TO_POLYGONS_CONVERTER = new MultiplePolyLineToPolygonsConverter();
    private final Relation.Ring ring;

    public RelationToMultiPolygonMemberConverter(Relation.Ring ring) {
        this.ring = ring;
    }

    @Override
    public Iterable<Polygon> convert(Relation relation) {
        ArrayList<PolyLine> candidates = new ArrayList<PolyLine>();
        ArrayList<Polygon> alreadyFormed = new ArrayList<Polygon>();
        if (!relation.isMultiPolygon()) {
            throw new CoreException("Not a MultiPolygon: {}", relation);
        }
        block4: for (RelationMember member : relation.members()) {
            AtlasEntity entity = member.getEntity();
            switch (this.ring) {
                case OUTER: {
                    if (!"outer".equals(member.getRole())) continue block4;
                    this.processEntity(entity, candidates, alreadyFormed);
                    continue block4;
                }
                case INNER: {
                    if (!"inner".equals(member.getRole())) continue block4;
                    this.processEntity(entity, candidates, alreadyFormed);
                    continue block4;
                }
            }
            throw new CoreException("Unknown ring type: {}", new Object[]{this.ring});
        }
        return new MultiIterable<Polygon>(alreadyFormed, MULTIPLE_POLY_LINE_TO_POLYGONS_CONVERTER.convert((Iterable<PolyLine>)candidates));
    }

    private void processEntity(AtlasEntity entity, List<PolyLine> candidates, List<Polygon> alreadyFormed) {
        if (entity instanceof Area) {
            alreadyFormed.add(((Area)entity).asPolygon());
        } else if (entity instanceof LineItem && (!(entity instanceof Edge) || ((Edge)entity).isMasterEdge())) {
            candidates.add(((LineItem)entity).asPolyLine());
        }
    }
}

