/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items.complex;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public abstract class ComplexEntity
implements AtlasObject {
    private static final long serialVersionUID = -553026286746440299L;
    private final Atlas atlas;
    private final AtlasEntity source;
    private Tuple<String, Throwable> invalidReason;

    protected ComplexEntity(AtlasEntity source) {
        this.source = source;
        this.atlas = source.getAtlas();
    }

    @Override
    public Rectangle bounds() {
        return this.getSource().bounds();
    }

    public boolean equals(Object other) {
        if (other instanceof ComplexEntity) {
            return other.getClass().equals(this.getClass()) && this.getSource().equals(((ComplexEntity)other).getSource());
        }
        return false;
    }

    public abstract List<ComplexEntityError> getAllInvalidations();

    @Override
    public Atlas getAtlas() {
        return this.atlas;
    }

    public Optional<ComplexEntityError> getError() {
        if (this.invalidReason == null) {
            return Optional.empty();
        }
        return Optional.of(new ComplexEntityError(this, this.invalidReason.getFirst(), this.invalidReason.getSecond()));
    }

    @Override
    public long getIdentifier() {
        return this.getSource().getIdentifier();
    }

    @Override
    public long getOsmIdentifier() {
        return this.source.getOsmIdentifier();
    }

    public AtlasEntity getSource() {
        return this.source;
    }

    @Override
    public Optional<String> getTag(String tagName) {
        return this.getSource().getTag(tagName);
    }

    @Override
    public Map<String, String> getTags() {
        return this.getSource().getTags();
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean isValid() {
        return this.invalidReason == null;
    }

    public abstract String toString();

    protected void setInvalidReason(String reason, Throwable oops) {
        this.invalidReason = new Tuple<String, Throwable>(reason, oops);
    }

    public static final class ComplexEntityError {
        private final ComplexEntity source;
        private final String reason;
        private final Throwable oops;

        public ComplexEntityError(ComplexEntity source, String reason) {
            this(source, reason, null);
        }

        public ComplexEntityError(ComplexEntity source, String reason, Throwable oops) {
            this.source = source;
            this.reason = reason;
            this.oops = oops;
        }

        public Throwable getException() {
            return this.oops;
        }

        public String getReason() {
            return this.reason;
        }

        public ComplexEntity getSource() {
            return this.source;
        }

        public String toString() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream(baos);
            stream.printf("%s\n", this.source);
            stream.printf("OSM id: %d\n", this.source.getOsmIdentifier());
            if (this.reason != null) {
                stream.printf("Why: %s\n", this.reason);
            }
            if (this.oops != null) {
                this.oops.printStackTrace(stream);
            }
            stream.close();
            return new String(baos.toByteArray(), Charset.forName("UTF-8"));
        }
    }
}

