/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;

public class RelationMember
implements Comparable<RelationMember> {
    private final String role;
    private final AtlasEntity entity;
    private final long relationIdentifier;

    public RelationMember(String role, AtlasEntity entity, long relationIdentifier) {
        this.role = role;
        this.entity = entity;
        this.relationIdentifier = relationIdentifier;
    }

    @Override
    public int compareTo(RelationMember other) {
        long identifier2;
        int itemTypeValue2;
        int itemTypeValue1 = this.getEntity().getType().getValue();
        int deltaTypeValue = itemTypeValue1 - (itemTypeValue2 = other.getEntity().getType().getValue());
        if (deltaTypeValue > 0) {
            return 1;
        }
        if (deltaTypeValue < 0) {
            return -1;
        }
        long identifier1 = this.getEntity().getIdentifier();
        long delta = identifier1 - (identifier2 = other.getEntity().getIdentifier());
        if (delta > 0L) {
            return 1;
        }
        if (delta < 0L) {
            return -1;
        }
        String thisRole = this.getRole();
        String otherRole = other.getRole();
        if (thisRole == null && otherRole == null) {
            return 0;
        }
        if (thisRole == null) {
            return -1;
        }
        if (otherRole == null) {
            return 1;
        }
        return thisRole.compareTo(otherRole);
    }

    public boolean equals(Object other) {
        if (other instanceof RelationMember) {
            RelationMember that = (RelationMember)other;
            return StringUtils.equals(this.getRole(), that.getRole()) && this.getRelationIdentifier() == that.getRelationIdentifier() && this.entity.getIdentifier() == that.getEntity().getIdentifier();
        }
        return false;
    }

    public AtlasEntity getEntity() {
        return this.entity;
    }

    public long getRelationIdentifier() {
        return this.relationIdentifier;
    }

    public String getRole() {
        return this.role;
    }

    public int hashCode() {
        return this.role.hashCode() + this.entity.hashCode() + Long.hashCode(this.relationIdentifier);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{Member: ID = ");
        builder.append(this.getEntity().getIdentifier());
        builder.append(", Type = ");
        builder.append((Object)this.getEntity().getType());
        builder.append(", Role = ");
        builder.append(this.getRole());
        builder.append("}");
        return builder.toString();
    }
}

