/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.items;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Relation
extends AtlasEntity
implements Iterable<RelationMember> {
    private static final Logger logger = LoggerFactory.getLogger(Relation.class);
    private static final long serialVersionUID = -9013894610780915685L;
    public static final Comparator<Relation> RELATION_ID_COMPARATOR = (relation1, relation2) -> Long.compare(relation1.getIdentifier(), relation2.getIdentifier());

    protected Relation(Atlas atlas) {
        super(atlas);
    }

    public abstract RelationMemberList allKnownOsmMembers();

    public abstract List<Relation> allRelationsWithSameOsmIdentifier();

    @Override
    public Rectangle bounds() {
        return this.boundsInternal(new LinkedHashSet<Long>());
    }

    public String configurableString(String betweenEachMemberAndRelation, String betweenEachMember) {
        StringBuilder builder = new StringBuilder();
        builder.append("[Relation: id=");
        builder.append(this.getIdentifier());
        builder.append(", [Members: \n\t\t\t\t");
        StringList list = new StringList();
        for (RelationMember member : this) {
            list.add(betweenEachMemberAndRelation + betweenEachMember + member.toString());
        }
        builder.append(list.join(", \n\t\t\t\t"));
        builder.append("\n\t\t\t");
        builder.append(betweenEachMemberAndRelation);
        builder.append("], ");
        builder.append(this.tagString());
        builder.append("]");
        return builder.toString();
    }

    public Set<AtlasObject> flatten() {
        HashSet<AtlasObject> relationMembers = new HashSet<AtlasObject>();
        LinkedList<Relation> toProcess = new LinkedList<Relation>();
        HashSet<Long> relationsSeen = new HashSet<Long>();
        toProcess.add(this);
        while (!toProcess.isEmpty()) {
            AtlasObject polledMember = (AtlasObject)toProcess.poll();
            if (polledMember instanceof Relation) {
                if (relationsSeen.contains(polledMember.getIdentifier())) continue;
                ((Relation)polledMember).members().forEach(member -> toProcess.add((Relation)member.getEntity()));
                relationsSeen.add(polledMember.getIdentifier());
                continue;
            }
            relationMembers.add(polledMember);
        }
        return relationMembers;
    }

    public RelationBean getBean() {
        RelationBean bean = new RelationBean();
        for (RelationMember member : this) {
            AtlasEntity entity = member.getEntity();
            bean.addItem(entity.getIdentifier(), member.getRole(), entity.getType());
        }
        return bean;
    }

    @Override
    public ItemType getType() {
        return ItemType.RELATION;
    }

    public boolean hasMultiPolygonMembers(Ring ring) {
        if (this.isMultiPolygon()) {
            block4: for (RelationMember member : this.members()) {
                switch (ring) {
                    case OUTER: {
                        if (!"outer".equals(member.getRole())) continue block4;
                        return true;
                    }
                    case INNER: {
                        if (!"inner".equals(member.getRole())) continue block4;
                        return true;
                    }
                }
                throw new CoreException("Unknown ring type: {}", new Object[]{ring});
            }
        }
        return false;
    }

    @Override
    public boolean intersects(GeometricSurface surface) {
        return this.intersectsInternal(surface, new LinkedHashSet<Long>());
    }

    public boolean isMultiPolygon() {
        return Validators.isOfType((Taggable)this, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.MULTIPOLYGON, RelationTypeTag.BOUNDARY});
    }

    @Override
    public Iterator<RelationMember> iterator() {
        return this.members().iterator();
    }

    public abstract RelationMemberList members();

    public abstract long osmRelationIdentifier();

    @Override
    public String toDiffViewFriendlyString() {
        String relationsString = this.parentRelationsAsDiffViewFriendlyString();
        StringBuilder builder = new StringBuilder();
        builder.append("[Relation: id=");
        builder.append(this.getIdentifier());
        builder.append(", [Members: ");
        StringList list = new StringList();
        for (RelationMember member : this) {
            list.add(member.toString());
        }
        builder.append(list.join(", "));
        builder.append("], ");
        builder.append("relations=(" + relationsString + "), ");
        builder.append(this.tagString());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public GeoJsonBuilder.LocationIterableProperties toGeoJsonBuildingBlock() {
        Map<String, String> tags = this.getTags();
        tags.put("identifier", String.valueOf(this.getIdentifier()));
        tags.put("osmIdentifier", String.valueOf(this.getOsmIdentifier()));
        tags.put("itemType", String.valueOf((Object)this.getType()));
        tags.put("relation", this.toSimpleString());
        return new GeoJsonBuilder.LocationIterableProperties(Location.CENTER, tags);
    }

    public String toSimpleString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[Relation: id=");
        builder.append(this.getIdentifier());
        builder.append(", [Members: ");
        StringList list = new StringList();
        for (RelationMember member : this) {
            list.add(member.toString());
        }
        builder.append(list.join(", "));
        builder.append("], ");
        builder.append(this.tagString());
        builder.append("]");
        return builder.toString();
    }

    public String toString() {
        return this.configurableString("", "");
    }

    protected Rectangle boundsInternal(Set<Long> parentRelationIdentifiers) {
        if (this.members().isEmpty()) {
            return Rectangle.MINIMUM;
        }
        ArrayList<Rectangle> itemsToConsider = new ArrayList<Rectangle>();
        for (AtlasEntity member : Iterables.stream(this).map(RelationMember::getEntity).filter(Objects::nonNull)) {
            if (member instanceof Relation) {
                long identifier = member.getIdentifier();
                if (parentRelationIdentifiers.contains(identifier)) continue;
                parentRelationIdentifiers.add(identifier);
                itemsToConsider.add(((Relation)member).boundsInternal(parentRelationIdentifiers));
                continue;
            }
            Rectangle bounds = member.bounds();
            if (bounds == null) continue;
            itemsToConsider.add(bounds);
        }
        if (Iterables.size(itemsToConsider) == 0L) {
            return Rectangle.MINIMUM;
        }
        return Rectangle.forLocated(itemsToConsider);
    }

    protected boolean intersectsInternal(GeometricSurface surface, Set<Long> parentRelationIdentifiers) {
        for (RelationMember member : this) {
            AtlasEntity entity = member.getEntity();
            if (entity instanceof Relation) {
                long identifier = entity.getIdentifier();
                if (parentRelationIdentifiers.contains(identifier)) continue;
                parentRelationIdentifiers.add(identifier);
                if (!((Relation)entity).intersectsInternal(surface, parentRelationIdentifiers)) continue;
                return true;
            }
            if (!entity.intersects(surface)) continue;
            return true;
        }
        return false;
    }

    public static enum Ring {
        OUTER,
        INNER;

    }
}

