/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.dynamic.policy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicAtlasPolicy {
    private static final Logger logger = LoggerFactory.getLogger(DynamicAtlasPolicy.class);
    private final Polygon maximumBounds;
    private final Sharding sharding;
    private final Function<Shard, Optional<Atlas>> atlasFetcher;
    private final Set<Shard> initialShards;
    private boolean extendIndefinitely = true;
    private boolean deferLoading = false;
    private Consumer<Set<Shard>> shardSetChecker;
    private Predicate<AtlasEntity> atlasEntitiesToConsiderForExpansion;
    private boolean aggressivelyExploreRelations;
    private Optional<MultiPolygon> shapeCoveringInitialShards;

    public DynamicAtlasPolicy(Function<Shard, Optional<Atlas>> atlasFetcher, Sharding sharding, MultiPolygon shapeCoveringInitialShards, Polygon maximumBounds) {
        this.shardSetChecker = set -> {};
        this.atlasEntitiesToConsiderForExpansion = entity -> true;
        this.aggressivelyExploreRelations = false;
        this.shapeCoveringInitialShards = Optional.empty();
        this.initialShards = new HashSet<Shard>();
        this.shapeCoveringInitialShards = Optional.of(shapeCoveringInitialShards);
        sharding.shards(shapeCoveringInitialShards).forEach(this.initialShards::add);
        this.atlasFetcher = atlasFetcher;
        this.maximumBounds = maximumBounds;
        this.sharding = sharding;
    }

    public DynamicAtlasPolicy(Function<Shard, Optional<Atlas>> atlasFetcher, Sharding sharding, Polygon shapeCoveringInitialShards, Polygon maximumBounds) {
        this.shardSetChecker = set -> {};
        this.atlasEntitiesToConsiderForExpansion = entity -> true;
        this.aggressivelyExploreRelations = false;
        this.shapeCoveringInitialShards = Optional.empty();
        this.initialShards = new HashSet<Shard>();
        this.shapeCoveringInitialShards = Optional.of(MultiPolygon.forPolygon(shapeCoveringInitialShards));
        sharding.shards(shapeCoveringInitialShards).forEach(this.initialShards::add);
        this.atlasFetcher = atlasFetcher;
        this.maximumBounds = maximumBounds;
        this.sharding = sharding;
    }

    public DynamicAtlasPolicy(Function<Shard, Optional<Atlas>> atlasFetcher, Sharding sharding, Set<Shard> initialShards, Polygon maximumBounds) {
        this.shardSetChecker = set -> {};
        this.atlasEntitiesToConsiderForExpansion = entity -> true;
        this.aggressivelyExploreRelations = false;
        this.shapeCoveringInitialShards = Optional.empty();
        this.initialShards = initialShards;
        this.atlasFetcher = atlasFetcher;
        this.maximumBounds = maximumBounds;
        this.sharding = sharding;
    }

    public DynamicAtlasPolicy(Function<Shard, Optional<Atlas>> atlasFetcher, Sharding sharding, Shard initialShard, Polygon maximumBounds) {
        this.shardSetChecker = set -> {};
        this.atlasEntitiesToConsiderForExpansion = entity -> true;
        this.aggressivelyExploreRelations = false;
        this.shapeCoveringInitialShards = Optional.empty();
        this.initialShards = new HashSet<Shard>();
        this.initialShards.add(initialShard);
        this.atlasFetcher = atlasFetcher;
        this.maximumBounds = maximumBounds;
        this.sharding = sharding;
    }

    public Predicate<AtlasEntity> getAtlasEntitiesToConsiderForExpansion() {
        return this.atlasEntitiesToConsiderForExpansion;
    }

    public Function<Shard, Optional<Atlas>> getAtlasFetcher() {
        return shard -> {
            if (this.maximumBounds.overlaps(shard.bounds())) {
                try {
                    return this.atlasFetcher.apply((Shard)shard);
                }
                catch (Throwable error) {
                    logger.error("Could not load shard {}, skipping.", (Object)shard.getName(), (Object)error);
                }
            } else {
                logger.debug("Skipping atlasFetcher for {} because shard bounds are outside the policy's maximumBounds", (Object)shard.getName());
            }
            return Optional.empty();
        };
    }

    public Set<Shard> getInitialShards() {
        return this.initialShards;
    }

    public MultiPolygon getInitialShardsBounds() {
        if (this.shapeCoveringInitialShards.isPresent()) {
            return this.shapeCoveringInitialShards.get();
        }
        MultiMap<Polygon, Polygon> outerToInners = new MultiMap<Polygon, Polygon>();
        this.initialShards.forEach(shard -> outerToInners.put(shard.bounds(), new ArrayList()));
        return new MultiPolygon(outerToInners);
    }

    public Polygon getMaximumBounds() {
        return this.maximumBounds;
    }

    public Sharding getSharding() {
        return this.sharding;
    }

    public Consumer<Set<Shard>> getShardSetChecker() {
        return this.shardSetChecker;
    }

    public boolean isAggressivelyExploreRelations() {
        return this.aggressivelyExploreRelations;
    }

    public boolean isDeferLoading() {
        return this.deferLoading;
    }

    public boolean isExtendIndefinitely() {
        return this.extendIndefinitely;
    }

    public DynamicAtlasPolicy withAggressivelyExploreRelations(boolean aggressivelyExploreRelations) {
        this.aggressivelyExploreRelations = aggressivelyExploreRelations;
        return this;
    }

    public DynamicAtlasPolicy withAtlasEntitiesToConsiderForExpansion(Predicate<AtlasEntity> atlasEntitiesToConsiderForExpansion) {
        this.atlasEntitiesToConsiderForExpansion = atlasEntitiesToConsiderForExpansion;
        return this;
    }

    public DynamicAtlasPolicy withDeferredLoading(boolean deferLoading) {
        this.deferLoading = deferLoading;
        return this;
    }

    public DynamicAtlasPolicy withExtendIndefinitely(boolean extendIndefinitely) {
        this.extendIndefinitely = extendIndefinitely;
        return this;
    }

    public DynamicAtlasPolicy withShardSetChecker(Consumer<Set<Shard>> shardSetChecker) {
        this.shardSetChecker = shardSetChecker;
        return this;
    }
}

