/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.dynamic;

import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicAtlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicEdge;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicRelation;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;

public class DynamicNode
extends Node {
    private static final long serialVersionUID = 7046248083667389625L;
    private final long identifier;

    protected DynamicNode(DynamicAtlas atlas, long identifier) {
        super(atlas);
        this.identifier = identifier;
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Location getLocation() {
        return this.subNode().getLocation();
    }

    @Override
    public Map<String, String> getTags() {
        return this.subNode().getTags();
    }

    @Override
    public SortedSet<Edge> inEdges() {
        return this.subNode().inEdges().stream().map(edge -> new DynamicEdge(this.dynamicAtlas(), edge.getIdentifier())).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public SortedSet<Edge> outEdges() {
        return this.subNode().outEdges().stream().map(edge -> new DynamicEdge(this.dynamicAtlas(), edge.getIdentifier())).collect(Collectors.toCollection(TreeSet::new));
    }

    @Override
    public Set<Relation> relations() {
        return this.subNode().relations().stream().map(relation -> new DynamicRelation(this.dynamicAtlas(), relation.getIdentifier())).collect(Collectors.toSet());
    }

    private DynamicAtlas dynamicAtlas() {
        return (DynamicAtlas)this.getAtlas();
    }

    private Node subNode() {
        Node result = this.dynamicAtlas().subNode(this.identifier);
        if (result != null) {
            return result;
        }
        throw new CoreException("DynamicAtlas {} moved too fast! {} {} is missing now.", this.dynamicAtlas().getName(), this.getClass().getSimpleName(), this.identifier);
    }
}

