/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.delta;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;

public class Diff
implements Comparable<Diff>,
Serializable {
    private static final long serialVersionUID = -1798331824716201841L;
    private final ItemType itemType;
    private final DiffType diffType;
    private final DiffReason diffReason;
    private final Atlas before;
    private final Atlas after;
    private final long identifier;

    public static String toDiffViewFriendlyString(Iterable<Diff> diffs) {
        String newLine = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("Diffset {");
        StringList list = new StringList();
        for (Diff diff : diffs) {
            list.add(newLine + diff.toDiffViewFriendlyString());
        }
        builder.append(list.join(newLine));
        builder.append(newLine + "}");
        return builder.toString();
    }

    public static String toGeoJson(Iterable<Diff> diffs) {
        return Diff.toGeoJson(diffs, val -> true);
    }

    public static String toGeoJson(Iterable<Diff> diffs, Predicate<Diff> filter) {
        return new GeoJsonBuilder().create(Iterables.stream(diffs).filter(diff -> diff.getItemType() != ItemType.RELATION).filter(filter).flatMap(Diff::processDiff).collect()).jsonObject().toString();
    }

    private static List<GeoJsonBuilder.LocationIterableProperties> processDiff(Diff diff) {
        ArrayList<GeoJsonBuilder.LocationIterableProperties> items = new ArrayList<GeoJsonBuilder.LocationIterableProperties>();
        AtlasEntity beforeEntity = diff.getBeforeEntity();
        Diff.processDiffEntity(diff, beforeEntity, items, "BEFORE");
        AtlasEntity afterEntity = diff.getAfterEntity();
        Diff.processDiffEntity(diff, afterEntity, items, "AFTER");
        return items;
    }

    private static void processDiffEntity(Diff diff, AtlasEntity entity, List<GeoJsonBuilder.LocationIterableProperties> items, String diffStage) {
        if (entity != null) {
            Map<String, String> tags = entity.getTags();
            tags.put("diff", diffStage);
            tags.put("diff:type", diff.getDiffType().name());
            tags.put("diff:reason", diff.getDiffReason().name());
            if (diff.getItemType() == ItemType.RELATION) {
                items.addAll(Diff.processRelationForGeoJson((Relation)entity, tags));
            } else {
                items.add(new GeoJsonBuilder.LocationIterableProperties(((AtlasItem)entity).getRawGeometry(), tags));
            }
        }
    }

    public static String toRelationsGeoJson(Iterable<Diff> diffs) {
        return Diff.toRelationsGeoJson(diffs, val -> true);
    }

    public static String toRelationsGeoJson(Iterable<Diff> diffs, Predicate<Diff> filter) {
        return new GeoJsonBuilder().create(Iterables.stream(diffs).filter(diff -> diff.getItemType() == ItemType.RELATION).filter(filter).flatMap(Diff::processDiff).collect()).jsonObject().toString();
    }

    public static String toString(Iterable<Diff> diffs) {
        StringBuilder builder = new StringBuilder();
        builder.append("[Diffs: ");
        StringList list = new StringList();
        for (Diff diff : diffs) {
            list.add("\n\t" + diff.toString());
        }
        builder.append(list.join(", "));
        builder.append("\n]");
        return builder.toString();
    }

    private static List<GeoJsonBuilder.LocationIterableProperties> processRelationForGeoJson(Relation relation, Map<String, String> parentTags) {
        Map<String, String> relationTags = relation.getTags();
        HashMap<String, String> modifiedRelationTags = new HashMap<String, String>(parentTags);
        for (String key : relationTags.keySet()) {
            modifiedRelationTags.put("[REL_ID:" + relation.getIdentifier() + "]" + key, relationTags.get(key));
        }
        ArrayList<GeoJsonBuilder.LocationIterableProperties> result = new ArrayList<GeoJsonBuilder.LocationIterableProperties>();
        for (RelationMember member : relation.members()) {
            if (member.getEntity() instanceof Relation) {
                Relation subRelation = (Relation)member.getEntity();
                result.addAll(Diff.processRelationForGeoJson(subRelation, modifiedRelationTags));
                continue;
            }
            AtlasItem item = (AtlasItem)member.getEntity();
            Map<String, String> modifiedTags = item.getTags();
            modifiedTags.putAll(modifiedRelationTags);
            result.add(new GeoJsonBuilder.LocationIterableProperties(item.getRawGeometry(), modifiedTags));
        }
        return result;
    }

    public Diff(ItemType itemType, DiffType diffType, DiffReason diffReason, Atlas before, Atlas after, long identifier) {
        this.itemType = itemType;
        this.diffType = diffType;
        this.diffReason = diffReason;
        this.before = before;
        this.after = after;
        this.identifier = identifier;
    }

    @Override
    public int compareTo(Diff other) {
        if (this.getDiffType() != other.getDiffType()) {
            return this.getDiffType().compareTo(other.getDiffType());
        }
        if (this.getItemType() != other.getItemType()) {
            return this.itemType.compareTo(other.getItemType());
        }
        long deltaIdentifier = this.getIdentifier() - other.getIdentifier();
        return deltaIdentifier > 0L ? 1 : (deltaIdentifier == 0L ? 0 : -1);
    }

    public Atlas getAfter() {
        return this.after;
    }

    public AtlasEntity getAfterEntity() {
        return this.itemType.entityForIdentifier(this.after, this.identifier);
    }

    public Atlas getBefore() {
        return this.before;
    }

    public AtlasEntity getBeforeEntity() {
        return this.itemType.entityForIdentifier(this.before, this.identifier);
    }

    public DiffReason getDiffReason() {
        return this.diffReason;
    }

    public DiffType getDiffType() {
        return this.diffType;
    }

    public long getIdentifier() {
        return this.identifier;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public boolean isAdded() {
        return DiffType.ADDED == this.getDiffType();
    }

    public boolean isChanged() {
        return DiffType.CHANGED == this.getDiffType();
    }

    public boolean isRemoved() {
        return DiffType.REMOVED == this.getDiffType();
    }

    public String toDiffViewFriendlyString() {
        String newLine = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("Diff {");
        builder.append(newLine);
        builder.append("diffType: " + (Object)((Object)this.diffType));
        builder.append(newLine);
        builder.append("diffReason: " + (Object)((Object)this.diffReason));
        builder.append(newLine);
        builder.append("Entity = " + (Object)((Object)this.itemType));
        builder.append(newLine);
        builder.append("ID = " + this.identifier);
        builder.append(newLine);
        if (this.getBeforeEntity() != null) {
            builder.append(this.getBeforeEntity().toDiffViewFriendlyString());
        } else {
            builder.append("null");
        }
        builder.append(newLine);
        builder.append(" -> ");
        builder.append(newLine);
        if (this.getAfterEntity() != null) {
            builder.append(this.getAfterEntity().toDiffViewFriendlyString());
        } else {
            builder.append("null");
        }
        builder.append(newLine);
        builder.append("}");
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[Diff: ");
        builder.append((Object)this.diffType);
        builder.append(", Entity = {");
        builder.append((Object)this.itemType);
        builder.append(", ID = ");
        builder.append(this.identifier);
        builder.append(", ");
        builder.append(this.getBeforeEntity());
        builder.append(" -> ");
        builder.append(this.getAfterEntity());
        builder.append("}]");
        return builder.toString();
    }

    public static enum DiffType {
        ADDED,
        CHANGED,
        REMOVED;

    }

    public static enum DiffReason {
        ADDED,
        REMOVED,
        TAGS,
        GEOMETRY_OR_TOPOLOGY,
        RELATION_MEMBER,
        RELATION_TOPOLOGY;

    }
}

