/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.command;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.creation.RawAtlasGenerator;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.WaySectionProcessor;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasCountrySlicer;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.tags.filters.ConfiguredTaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.runtime.FlexibleSubCommand;

public class OsmPbfToAtlasSubCommand
implements FlexibleSubCommand {
    private static final String NAME = "pbf-to-atlas";
    private static final String DESCRIPTION = "Converts a PBF to an Atlas file.";
    private static final Command.Switch<File> INPUT_PARAMETER = new Command.Switch("pbf", "Input PBF path", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> OUTPUT_PARAMETER = new Command.Switch("output", "Output Atlas file path", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> EDGE_FILTER_PARAMETER = new Command.Switch("edge-filter", "Path to a local json filter for determining Edges", File::new, Command.Optionality.OPTIONAL);
    private static final Command.Switch<File> NODE_FILTER_PARAMETER = new Command.Switch("node-filter", "Path to a local json filter for OSM nodes", File::new, Command.Optionality.OPTIONAL);
    private static final Command.Switch<File> RELATION_FILTER_PARAMETER = new Command.Switch("relation-filter", "Path to a local json filter for OSM relations", File::new, Command.Optionality.OPTIONAL);
    private static final Command.Switch<File> WAY_FILTER_PARAMETER = new Command.Switch("way-filter", "Path to a local json filter for OSM ways", File::new, Command.Optionality.OPTIONAL);
    private static final Command.Switch<File> WAY_SECTION_FILTER_PARAMETER = new Command.Switch("way-section-filter", "Path to a local json filter for determining where to way section", File::new, Command.Optionality.OPTIONAL);
    private static final Command.Switch<Boolean> LOAD_RELATIONS_PARAMETER = new Command.Switch("load-relations", "Whether to load Relations (boolean)", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "true");
    private static final Command.Switch<Boolean> LOAD_WAYS_PARAMETER = new Command.Switch("load-ways", "Whether to load ways (boolean)", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "true");
    private static final Command.Switch<Set<String>> COUNTRY_CODES_PARAMETER = new Command.Switch("country-codes", "Countries from the country map to convert (comma separated ISO3 codes)", code -> Arrays.stream(code.split(",")).collect(Collectors.toSet()), Command.Optionality.OPTIONAL);
    private static final Command.Switch<File> COUNTRY_MAP_PARAMETER = new Command.Switch("country-boundary-map", "Path to a local WKT or shp file containing a country boundary map", File::new, Command.Optionality.OPTIONAL);
    private static final Command.Switch<Boolean> COUNTRY_SLICING_PARAMETER = new Command.Switch("country-slicing", "Whether to perform country slicing (boolean)", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "true");

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Command.SwitchList switches() {
        return new Command.SwitchList().with(INPUT_PARAMETER, OUTPUT_PARAMETER, EDGE_FILTER_PARAMETER, NODE_FILTER_PARAMETER, RELATION_FILTER_PARAMETER, WAY_FILTER_PARAMETER, WAY_SECTION_FILTER_PARAMETER, LOAD_RELATIONS_PARAMETER, LOAD_WAYS_PARAMETER, COUNTRY_CODES_PARAMETER, COUNTRY_MAP_PARAMETER, COUNTRY_SLICING_PARAMETER);
    }

    @Override
    public void usage(PrintStream writer) {
        writer.println("-pbf=/path/to/pbf : pbf to convert");
        writer.println("-output=/path/to/output/atlas : Atlas file to output to");
        writer.println("-edge-filter=/path/to/json/edge/filter : json filter to determine Edges");
        writer.println("-node-filter=/path/to/json/node/filter : json filter for OSM nodes");
        writer.println("-relation-filter=/path/to/json/relation/filter : json filter for OSM relations");
        writer.println("-way-filter=/path/to/json/way/filter : json filter for OSM ways");
        writer.println("-load-relations=boolean : whether to load Relations; defaults to true");
        writer.println("-load-ways=boolean : whether to load ways; defaults to true");
        writer.println("-country-codes=list,of,ISO3,codes : countries from the country map to convert");
        writer.println("-country-boundary-map=/path/to/WKT/or/shp : a WKT or shp file containing a country boundary map");
        writer.println("-country-slicing=boolean : whether to perform country slicing; defaults to true");
        writer.println("-way-section-filter=/path/to/json/way/section/filter : json filter to determine where to way section");
    }

    @Override
    public int execute(CommandMap map) {
        AtlasLoadingOption options = this.getAtlasLoadingOption(map);
        Atlas atlas = new RawAtlasGenerator((File)map.get(INPUT_PARAMETER), options, MultiPolygon.MAXIMUM).build();
        if (options.isCountrySlicing()) {
            atlas = new RawAtlasCountrySlicer(options.getCountryCodes(), options.getCountryBoundaryMap()).slice(atlas);
        }
        atlas = new WaySectionProcessor(atlas, options).run();
        atlas.save((File)map.get(OUTPUT_PARAMETER));
        return 0;
    }

    private CountryBoundaryMap getCountryBoundaryMap(CommandMap map) {
        Optional<?> countryMapOption = map.getOption(COUNTRY_MAP_PARAMETER);
        CountryBoundaryMap countryMap = CountryBoundaryMap.fromBoundaryMap(Collections.singletonMap("UNK", MultiPolygon.MAXIMUM));
        if (countryMapOption.isPresent()) {
            File countryMapFile = (File)countryMapOption.get();
            if (FilenameUtils.isExtension(countryMapFile.getName(), "txt")) {
                countryMap = CountryBoundaryMap.fromPlainText(countryMapFile);
            } else if (FilenameUtils.isExtension(countryMapFile.getName(), "shp")) {
                countryMap = CountryBoundaryMap.fromShapeFile(countryMapFile.getFile());
            }
        }
        return countryMap;
    }

    private AtlasLoadingOption getAtlasLoadingOption(CommandMap map) {
        CountryBoundaryMap countryMap = this.getCountryBoundaryMap(map);
        AtlasLoadingOption options = AtlasLoadingOption.createOptionWithAllEnabled(countryMap);
        map.getOption(EDGE_FILTER_PARAMETER).ifPresent(filter -> options.setEdgeFilter(new ConfiguredTaggableFilter(new StandardConfiguration((File)filter))));
        map.getOption(NODE_FILTER_PARAMETER).ifPresent(filter -> options.setOsmPbfNodeFilter(new ConfiguredTaggableFilter(new StandardConfiguration((File)filter))));
        map.getOption(RELATION_FILTER_PARAMETER).ifPresent(filter -> options.setOsmPbfRelationFilter(new ConfiguredTaggableFilter(new StandardConfiguration((File)filter))));
        map.getOption(WAY_FILTER_PARAMETER).ifPresent(filter -> options.setOsmPbfWayFilter(new ConfiguredTaggableFilter(new StandardConfiguration((File)filter))));
        map.getOption(WAY_SECTION_FILTER_PARAMETER).ifPresent(filter -> options.setWaySectionFilter(new ConfiguredTaggableFilter(new StandardConfiguration((File)filter))));
        map.getOption(LOAD_RELATIONS_PARAMETER).ifPresent(options::setLoadAtlasRelation);
        map.getOption(LOAD_WAYS_PARAMETER).ifPresent(bool -> {
            options.setLoadAtlasLine((boolean)bool);
            options.setLoadAtlasEdge((boolean)bool);
        });
        map.getOption(COUNTRY_CODES_PARAMETER).ifPresent(options::setAdditionalCountryCodes);
        map.getOption(COUNTRY_SLICING_PARAMETER).ifPresent(options::setCountrySlicing);
        return options;
    }
}

