/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.changeset;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.geography.atlas.changeset.ChangeAction;
import org.openstreetmap.atlas.geography.atlas.changeset.ChangeItem;
import org.openstreetmap.atlas.geography.atlas.changeset.ChangeSet;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;

public class SimpleChangeSet
implements ChangeSet {
    private static final long serialVersionUID = -6499530503182134327L;
    private final Map<String, ChangeItem> map = new HashMap<String, ChangeItem>();
    private String version = "unknown";
    private String description = "";

    private static String computeKey(long identifier, ItemType type, ChangeAction action) {
        return identifier + type.toShortString() + (Object)((Object)action);
    }

    @Override
    public boolean add(ChangeItem changeItem) {
        return this.map.put(this.computeKey(changeItem), changeItem) != null;
    }

    @Override
    public boolean addAll(Collection<? extends ChangeItem> changeItems) {
        boolean state = false;
        for (ChangeItem changeItem : changeItems) {
            state = this.add(changeItem) || state;
        }
        return state;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(long identifier, ItemType type) {
        for (ChangeAction action : ChangeAction.values()) {
            if (!this.map.containsKey(SimpleChangeSet.computeKey(identifier, type, action))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(long identifier, ItemType type, ChangeAction action) {
        return this.map.containsKey(SimpleChangeSet.computeKey(identifier, type, action));
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof ChangeItem)) {
            return false;
        }
        return this.map.containsKey(this.computeKey((ChangeItem)object));
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return collection.stream().allMatch(this::contains);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SimpleChangeSet)) {
            return false;
        }
        SimpleChangeSet that = (SimpleChangeSet)other;
        return StringUtils.equals(this.getVersion(), that.getVersion()) && StringUtils.equals(this.getDescription(), that.getDescription()) && this.map.equals(that.map);
    }

    @Override
    public Optional<ChangeItem> get(long identifier, ItemType type) {
        for (ChangeAction action : ChangeAction.values()) {
            ChangeItem item = this.map.get(SimpleChangeSet.computeKey(identifier, type, action));
            if (item == null) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    @Override
    public Optional<ChangeItem> get(long identifier, ItemType type, ChangeAction action) {
        return Optional.ofNullable(this.map.get(SimpleChangeSet.computeKey(identifier, type, action)));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Iterable<String> getSourceNames() {
        ArrayList<String> sourceNames = new ArrayList<String>();
        this.iterator().forEachRemaining(changeItem -> sourceNames.add(changeItem.getSourceName()));
        return sourceNames;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getVersion(), this.getDescription(), this.map);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<ChangeItem> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public Iterator<ChangeItem> iterator(ChangeAction action) {
        return this.filterIterator(this.iterator(), item -> item.getAction() == action);
    }

    @Override
    public Iterator<ChangeItem> iterator(ItemType type) {
        return this.filterIterator(this.iterator(), item -> item.getType() == type);
    }

    @Override
    public Iterator<ChangeItem> iterator(ItemType type, ChangeAction action) {
        return this.filterIterator(this.iterator(), item -> item.getType() == type && item.getAction() == action);
    }

    @Override
    public boolean remove(Object obj) {
        return this.map.remove(this.computeKey((ChangeItem)obj)) != null;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Set<ChangeItem> subSet(ChangeAction action) {
        return this.stream().filter(item -> item.getAction() == action).collect(Collectors.toSet());
    }

    @Override
    public Set<ChangeItem> subSet(ItemType type) {
        return this.stream().filter(item -> item.getType() == type).collect(Collectors.toSet());
    }

    @Override
    public Set<ChangeItem> subSet(ItemType type, ChangeAction action) {
        return this.stream().filter(item -> item.getType() == type && item.getAction() == action).collect(Collectors.toSet());
    }

    @Override
    public Object[] toArray() {
        return this.map.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return this.map.values().toArray(array);
    }

    private String computeKey(ChangeItem item) {
        return SimpleChangeSet.computeKey(item.getIdentifier(), item.getType(), item.getAction());
    }

    private Iterator<ChangeItem> filterIterator(final Iterator<ChangeItem> parent, final Predicate<ChangeItem> predicate) {
        return new AbstractIterator<ChangeItem>(){

            @Override
            protected ChangeItem computeNext() {
                while (parent.hasNext()) {
                    ChangeItem item = (ChangeItem)parent.next();
                    if (item == null || !predicate.test(item)) continue;
                    return item;
                }
                return (ChangeItem)this.endOfData();
            }
        };
    }
}

