/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.changeset;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.changeset.ChangeAction;
import org.openstreetmap.atlas.geography.atlas.changeset.ChangeItemMember;
import org.openstreetmap.atlas.geography.atlas.changeset.MutableChangeItem;
import org.openstreetmap.atlas.geography.atlas.changeset.SimpleChangeItemMember;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class SimpleChangeItem
implements MutableChangeItem {
    private static final long serialVersionUID = 3817694187693336803L;
    private String sourceName;
    private Map<String, String> tags;
    private long identifier;
    private ItemType type;
    private ChangeAction action;
    private Iterable<Location> geometry;
    private double score = 1.0;
    private final Set<ChangeItemMember> members;

    public SimpleChangeItem() {
        this.members = new HashSet<ChangeItemMember>();
    }

    public SimpleChangeItem(long identifier, String sourceName, ItemType type, ChangeAction action, Iterable<Location> geometry, Map<String, String> tags) {
        this.identifier = identifier;
        this.sourceName = sourceName;
        this.type = type;
        this.action = action;
        this.geometry = geometry;
        this.tags = tags;
        this.members = new HashSet<ChangeItemMember>();
    }

    @Override
    public void addAllMembers(Iterable<ChangeItemMember> members) throws CoreException {
        this.assertTypeIsRelation();
        members.forEach(member -> this.members.add((ChangeItemMember)member));
    }

    @Override
    public void addMember(ChangeItemMember member) throws CoreException {
        this.assertTypeIsRelation();
        this.members.add(member);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SimpleChangeItem)) {
            return false;
        }
        SimpleChangeItem that = (SimpleChangeItem)other;
        return this.getIdentifier() == that.getIdentifier() && this.getType() == that.getType() && this.getAction() == that.getAction() && StringUtils.equals(this.getSourceName(), that.getSourceName()) && this.getScore() == that.getScore() && Iterables.equals(this.getMembers(), that.getMembers()) && Iterables.equals(this.getGeometry(), that.getGeometry());
    }

    @Override
    public ChangeAction getAction() {
        return this.action;
    }

    @Override
    public Iterable<Location> getGeometry() {
        return this.geometry;
    }

    @Override
    public long getIdentifier() {
        return this.identifier;
    }

    @Override
    public Iterable<ChangeItemMember> getMembers() {
        return this.members;
    }

    @Override
    public Optional<RelationBean> getRelationBean() {
        this.assertTypeIsRelation();
        if (this.members.isEmpty()) {
            return Optional.empty();
        }
        RelationBean bean = new RelationBean();
        this.members.forEach(member -> bean.addItem(member.getIdentifier(), member.getRole(), member.getType()));
        return Optional.of(bean);
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public Optional<String> getTag(String key) {
        return Optional.ofNullable(this.tags.get(key));
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public ItemType getType() {
        return this.type;
    }

    public int hashCode() {
        return (int)this.identifier;
    }

    @Override
    public boolean removeMember(long identifier, String role, ItemType type) throws CoreException {
        this.assertTypeIsRelation();
        return this.members.remove(new SimpleChangeItemMember(identifier, role, type));
    }

    @Override
    public void setAction(ChangeAction action) {
        this.action = action;
    }

    @Override
    public void setGeometry(Iterable<Location> geometry) throws CoreException {
        this.assertTypeIsNotRelation();
        this.geometry = geometry;
    }

    @Override
    public void setIdentifier(long identifier) {
        this.identifier = identifier;
    }

    public void setMembers(Iterable<ChangeItemMember> members) {
        this.members.clear();
        this.addAllMembers(members);
    }

    @Override
    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    @Override
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @Override
    public void setType(ItemType type) {
        this.type = type;
    }

    private void assertTypeIsNotRelation() {
        if (this.getType() == ItemType.RELATION) {
            throw new CoreException("Cannot execute this on a ChangeItem with type {}", new Object[]{this.getType()});
        }
    }

    private void assertTypeIsRelation() {
        if (this.getType() != ItemType.RELATION) {
            throw new CoreException("Cannot execute this on a ChangeItem with type {}", new Object[]{this.getType()});
        }
    }
}

