/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.changeset;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Optional;
import org.openstreetmap.atlas.geography.atlas.changeset.ChangeSet;
import org.openstreetmap.atlas.geography.atlas.changeset.ChangeSetDeserializer;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryChangeSetDeserializer
implements ChangeSetDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(BinaryChangeSetDeserializer.class);
    private final ObjectInputStream resource;
    private boolean hasMore;

    public BinaryChangeSetDeserializer(Resource resourceToReadFrom) throws IOException {
        this.resource = new ObjectInputStream(resourceToReadFrom.read());
        this.hasMore = true;
    }

    @Override
    public void close() throws Exception {
        this.resource.close();
    }

    @Override
    public Optional<ChangeSet> get() {
        if (!this.hasMore) {
            return Optional.empty();
        }
        ChangeSet changeSet = null;
        try {
            changeSet = (ChangeSet)this.resource.readObject();
        }
        catch (EOFException e) {
            this.hasMore = false;
            try {
                this.close();
            }
            catch (Exception closeException) {
                logger.error("ChangeSet resource close is failed.", (Throwable)closeException);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error("ChangeSet deserialization is failed.", (Throwable)e);
        }
        return Optional.ofNullable(changeSet);
    }
}

