/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.builder.store;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveEdge;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveRouteIdentifier;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Route;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public final class AtlasPrimitiveRoute
implements Iterable<AtlasPrimitiveEdge>,
Serializable {
    private static final long serialVersionUID = 804872809334744220L;
    public static final Comparator<AtlasPrimitiveRoute> ROUTE_SIZE_COMPARATOR = (route1, route2) -> new CompareToBuilder().append(route2.size(), route1.size()).append(route1.hashCode(), route2.hashCode()).toComparison();
    private final List<AtlasPrimitiveEdge> primitiveRoute;

    public static AtlasPrimitiveRoute from(AtlasPrimitiveEdge ... primitiveEdges) {
        return new AtlasPrimitiveRoute(Arrays.asList(primitiveEdges));
    }

    public static AtlasPrimitiveRoute from(AtlasPrimitiveRouteIdentifier atlasPrimitiveRouteIdentifier, Atlas atlas) {
        List<Edge> fromEdges = Iterables.stream(atlasPrimitiveRouteIdentifier).map(edgeIdentifier -> atlas.edge(edgeIdentifier.getIdentifier())).collectToList();
        return AtlasPrimitiveRoute.from(fromEdges);
    }

    public static AtlasPrimitiveRoute from(List<Edge> edges) {
        return new AtlasPrimitiveRoute(edges.stream().map(AtlasPrimitiveEdge::from).collect(Collectors.toList()));
    }

    public static Optional<AtlasPrimitiveRoute> from(Route route) {
        if (route != null && route.size() > 0) {
            return Optional.of(new AtlasPrimitiveRoute(Iterables.translate(route, AtlasPrimitiveEdge::from)));
        }
        return Optional.empty();
    }

    public AtlasPrimitiveRoute(Iterable<AtlasPrimitiveEdge> primitiveEdges) {
        this.primitiveRoute = ImmutableList.copyOf(primitiveEdges);
    }

    public PolyLine asPolyLine() {
        ArrayList<Location> locations = new ArrayList<Location>();
        Location lastLocation = null;
        for (AtlasPrimitiveEdge edge : this.primitiveRoute) {
            PolyLine polyLine = edge.getPolyLine();
            locations.addAll(polyLine);
            lastLocation = polyLine.last();
            locations.remove(lastLocation);
        }
        locations.add(lastLocation);
        return new PolyLine((List<? extends Location>)locations);
    }

    public AtlasPrimitiveEdge end() {
        if (this.primitiveRoute.size() > 0) {
            return this.primitiveRoute.get(this.primitiveRoute.size() - 1);
        }
        throw new CoreException("Illegal State : Empty route");
    }

    public boolean equals(Object other) {
        if (other instanceof AtlasPrimitiveRoute) {
            AtlasPrimitiveRoute that = (AtlasPrimitiveRoute)other;
            if (this.size() == that.size()) {
                return new EqualsBuilder().append(this.start().start(), that.start().start()).append(this.end().end(), that.end().end()).append(this.primitiveRoute, that.primitiveRoute).isEquals();
            }
        }
        return false;
    }

    public Optional<Route> getRoute(Atlas atlas) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (AtlasPrimitiveEdge primitiveEdge : this.primitiveRoute) {
            Edge edge = atlas.edge(primitiveEdge.getIdentifier());
            if (edge == null) {
                return Optional.empty();
            }
            edges.add(edge);
        }
        return Optional.of(Route.forEdges(edges));
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.start().start()).append(this.end().end()).append(Iterables.asList(this)).hashCode();
    }

    public int indexOf(AtlasPrimitiveEdge primitiveEdge) {
        return this.primitiveRoute.indexOf(primitiveEdge);
    }

    public boolean isOverlappedBy(AtlasPrimitiveRoute primitiveRoute) {
        return AtlasPrimitiveRouteIdentifier.from(this).isOverlappedBy(AtlasPrimitiveRouteIdentifier.from(primitiveRoute));
    }

    public boolean isOverlappedBy(Route route) {
        Optional<AtlasPrimitiveRoute> atlasPrimitiveRoute = AtlasPrimitiveRoute.from(route);
        return atlasPrimitiveRoute.isPresent() && this.isOverlappedBy(atlasPrimitiveRoute.get());
    }

    @Override
    public Iterator<AtlasPrimitiveEdge> iterator() {
        return this.primitiveRoute.iterator();
    }

    public int overlapCount(AtlasPrimitiveRoute subRoute) {
        int overlapCount = 0;
        if (this.primitiveRoute == null || subRoute == null) {
            return overlapCount;
        }
        Iterator<AtlasPrimitiveEdge> subRouteIterator = subRoute.iterator();
        AtlasPrimitiveEdge subRouteEdge = subRouteIterator.hasNext() ? subRouteIterator.next() : null;
        for (AtlasPrimitiveEdge edge : this.primitiveRoute) {
            if (subRouteEdge == null) break;
            if (edge.equals(subRouteEdge)) {
                if (!subRouteIterator.hasNext()) {
                    ++overlapCount;
                    subRouteIterator = subRoute.iterator();
                }
            } else {
                subRouteIterator = subRoute.iterator();
                if (edge.equals(subRoute.start())) {
                    subRouteEdge = subRouteIterator.hasNext() ? subRouteIterator.next() : null;
                }
            }
            subRouteEdge = subRouteIterator.hasNext() ? subRouteIterator.next() : null;
        }
        return overlapCount;
    }

    public int size() {
        return this.primitiveRoute.size();
    }

    public AtlasPrimitiveEdge start() {
        if (this.primitiveRoute.size() > 0) {
            return this.primitiveRoute.get(0);
        }
        throw new CoreException("Illegal State : Empty route");
    }

    public List<AtlasPrimitiveEdge> subRoute(int fromIndex, int toIndex) {
        return this.primitiveRoute.subList(fromIndex, toIndex);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[AtlasPrimitiveRoute: ");
        builder.append(this.primitiveRoute.stream().map(edge -> edge.toString()).collect(Collectors.joining(", ")));
        builder.append("]");
        return builder.toString();
    }
}

