/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.builder.store;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveEdge;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveEntity;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveLocationItem;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveRoute;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveRouteIdentifier;
import org.openstreetmap.atlas.geography.atlas.items.complex.bignode.BigNode;
import org.openstreetmap.atlas.geography.atlas.items.complex.bignode.RestrictedPath;

public class AtlasPrimitiveBigNode
extends AtlasPrimitiveEntity {
    private static final long serialVersionUID = -1722511104597663348L;
    private final Set<AtlasPrimitiveLocationItem> nodes;
    private final Set<AtlasPrimitiveEdge> edges;
    private final Set<AtlasPrimitiveRoute> paths;
    private final Set<AtlasPrimitiveRouteIdentifier> restrictedPaths;
    private final BigNode.Type type;

    public static AtlasPrimitiveBigNode from(BigNode bigNode) {
        return AtlasPrimitiveBigNode.from(bigNode, false, BigNode.Path.SHORTEST);
    }

    public static AtlasPrimitiveBigNode from(BigNode bigNode, boolean storeRestrictedPaths, BigNode.Path pathType) {
        Set<AtlasPrimitiveRoute> paths;
        Set<AtlasPrimitiveLocationItem> nodes = bigNode.nodes().stream().map(node -> AtlasPrimitiveLocationItem.from(node)).collect(Collectors.toSet());
        Set<AtlasPrimitiveEdge> edges = bigNode.edges().stream().map(edge -> AtlasPrimitiveEdge.from(edge)).collect(Collectors.toSet());
        switch (pathType) {
            case SHORTEST: {
                paths = bigNode.shortestPaths().stream().map(AtlasPrimitiveRoute::from).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
                break;
            }
            case ALL: {
                paths = bigNode.allPaths().stream().map(AtlasPrimitiveRoute::from).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
                break;
            }
            default: {
                throw new CoreException("Invalid Path Type: {}", new Object[]{pathType});
            }
        }
        Set<AtlasPrimitiveRouteIdentifier> restrictedPaths = storeRestrictedPaths ? bigNode.turnRestrictions().stream().map(RestrictedPath::getRoute).map(AtlasPrimitiveRoute::from).filter(Optional::isPresent).map(Optional::get).map(AtlasPrimitiveRouteIdentifier::from).collect(Collectors.toSet()) : Collections.emptySet();
        return new AtlasPrimitiveBigNode(bigNode.getIdentifier(), nodes, edges, paths, restrictedPaths, bigNode.getTags(), bigNode.getType());
    }

    public AtlasPrimitiveBigNode(long identifier, Set<AtlasPrimitiveLocationItem> nodes, Set<AtlasPrimitiveEdge> edges, Set<AtlasPrimitiveRoute> paths, Set<AtlasPrimitiveRouteIdentifier> restrictedPaths, Map<String, String> tags, BigNode.Type type) {
        super(identifier, tags);
        this.nodes = nodes;
        this.edges = edges;
        this.paths = paths;
        this.type = type;
        this.restrictedPaths = restrictedPaths;
    }

    @Override
    public Rectangle bounds() {
        return Rectangle.forLocated(this.nodes);
    }

    public Set<AtlasPrimitiveEdge> edges() {
        return this.edges;
    }

    public Set<AtlasPrimitiveRouteIdentifier> getRestrictedPaths() {
        return this.restrictedPaths;
    }

    public Set<AtlasPrimitiveEdge> inEdges() {
        return this.edges().stream().filter(edge -> !this.nodesContain(edge.start())).collect(Collectors.toSet());
    }

    public Set<AtlasPrimitiveEdge> junctionEdges() {
        return this.edges().stream().filter(edge -> this.nodesContain(edge.start()) && this.nodesContain(edge.end())).collect(Collectors.toSet());
    }

    public Set<Location> nodeLocations() {
        return this.nodes().stream().map(AtlasPrimitiveLocationItem::getLocation).collect(Collectors.toSet());
    }

    public Set<AtlasPrimitiveLocationItem> nodes() {
        return this.nodes;
    }

    public boolean nodesContain(Location location) {
        return this.nodes.stream().filter(node -> node.getLocation().equals(location)).count() > 0L;
    }

    public Set<AtlasPrimitiveEdge> outEdges() {
        return this.edges().stream().filter(edge -> !this.nodeLocations().contains(edge.end())).collect(Collectors.toSet());
    }

    public Set<AtlasPrimitiveRoute> paths() {
        return this.paths;
    }

    public String toString() {
        return "[AtlasPrimitiveBigNode: nodes=" + this.nodes().stream().map(node -> node.getIdentifier()).collect(Collectors.toSet()) + "]";
    }

    public BigNode.Type type() {
        return this.type;
    }
}

