/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas.builder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class RelationBean
implements Serializable {
    private static final long serialVersionUID = 8511830231633569713L;
    private final List<Long> memberIdentifiers = new ArrayList<Long>();
    private final List<String> memberRoles = new ArrayList<String>();
    private final List<ItemType> memberTypes = new ArrayList<ItemType>();

    public void addItem(Long identifier, String role, ItemType itemType) {
        this.memberIdentifiers.add(identifier);
        this.memberRoles.add(role);
        this.memberTypes.add(itemType);
    }

    public boolean equals(Object other) {
        if (other instanceof RelationBean) {
            RelationBean that = (RelationBean)other;
            return Iterables.equals(this.getMemberIdentifiers(), that.getMemberIdentifiers()) && Iterables.equals(this.getMemberRoles(), that.getMemberRoles()) && Iterables.equals(this.getMemberTypes(), that.getMemberTypes());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getMemberIdentifiers(), this.getMemberRoles(), this.getMemberTypes());
    }

    public List<Long> getMemberIdentifiers() {
        return this.memberIdentifiers;
    }

    public List<String> getMemberRoles() {
        return this.memberRoles;
    }

    public List<ItemType> getMemberTypes() {
        return this.memberTypes;
    }

    public boolean isEmpty() {
        return this.memberIdentifiers.isEmpty();
    }

    public int size() {
        return this.memberIdentifiers.size();
    }

    public String toString() {
        return "RelationBean [memberIdentifiers=" + this.memberIdentifiers + ", memberRoles=" + this.memberRoles + ", memberTypes=" + this.memberTypes + "]";
    }
}

