/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.sharding.DynamicTileSharding;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardFileOverlapsPolygon
implements Predicate<Resource> {
    private static final Logger logger = LoggerFactory.getLogger(ShardFileOverlapsPolygon.class);
    public static final String DEFAULT_SHARD_FILE_REGEX = "^.+_(\\d{1,2}-\\d+-\\d+)\\.atlas(\\.gz)?$";
    private final Pattern shardFilePattern;
    private final Set<String> shardsOverlappingPolygon;

    public ShardFileOverlapsPolygon(DynamicTileSharding shardingTree, Polygon bounds) {
        this(shardingTree, bounds, DEFAULT_SHARD_FILE_REGEX);
    }

    public ShardFileOverlapsPolygon(DynamicTileSharding shardingTree, Polygon bounds, String shardFileRegex) {
        this.shardFilePattern = Pattern.compile(shardFileRegex);
        this.shardsOverlappingPolygon = new HashSet<String>();
        shardingTree.shards(bounds).forEach(shard -> this.shardsOverlappingPolygon.add(shard.getName()));
    }

    @Override
    public boolean test(Resource resource) {
        boolean result = false;
        String resourceName = resource.getName();
        if (resourceName != null) {
            Matcher matcher = this.shardFilePattern.matcher(resourceName);
            if (matcher.find()) {
                String shardName = matcher.group(1);
                if (this.shardsOverlappingPolygon.contains(shardName)) {
                    logger.debug("Resource {} overlaps polygon.", (Object)resourceName);
                    result = true;
                } else {
                    logger.debug("Resource {} does not overlap polygon.", (Object)resourceName);
                }
            } else {
                logger.debug("Resource {} does not match shard filename pattern.", (Object)resourceName);
            }
        } else {
            logger.debug("Resource {} name is null.", (Object)resource.toString());
        }
        return result;
    }
}

