/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.builder.RelationBean;
import org.openstreetmap.atlas.geography.atlas.builder.text.TextAtlasBuilder;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.geography.atlas.items.SnappedEdge;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlasBuilder;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.geography.geojson.GeoJsonObject;
import org.openstreetmap.atlas.proto.builder.ProtoAtlasBuilder;
import org.openstreetmap.atlas.streaming.Streams;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.JsonWriter;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.collections.StreamIterable;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.scalars.Distance;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BareAtlas
implements Atlas {
    private static final long serialVersionUID = 4733707438968864018L;
    private static final Logger logger = LoggerFactory.getLogger(BareAtlas.class);
    private static final int MAXIMUM_RELATION_DEPTH = 500;
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private static final AtomicInteger ATLAS_IDENTIFIER_FACTORY = new AtomicInteger();
    private transient String name;
    private final transient int identifier = ATLAS_IDENTIFIER_FACTORY.getAndIncrement();

    protected BareAtlas() {
    }

    @Override
    public Iterable<Area> areas(Predicate<Area> matcher) {
        return Iterables.filter(this.areas(), matcher);
    }

    @Override
    public GeoJsonObject asGeoJson() {
        return this.asGeoJson(entity -> true);
    }

    @Override
    public GeoJsonObject asGeoJson(Predicate<AtlasEntity> matcher) {
        return new GeoJsonBuilder().create(Iterables.filterTranslate(this.entities(), atlasEntity -> atlasEntity.toGeoJsonBuildingBlock(), matcher));
    }

    @Override
    public Iterable<Edge> edges(Predicate<Edge> matcher) {
        return Iterables.filter(this.edges(), matcher);
    }

    @Override
    public Iterable<AtlasEntity> entities() {
        return new MultiIterable<AtlasEntity>(this.items(), this.relations());
    }

    @Override
    public <M extends AtlasEntity> Iterable<M> entities(ItemType type, Class<M> memberClass) {
        if (type.getMemberClass() != memberClass) {
            throw new CoreException("ItemType {} and class {} do not match!", new Object[]{type, memberClass.getSimpleName()});
        }
        switch (type) {
            case NODE: {
                return this.nodes();
            }
            case EDGE: {
                return this.edges();
            }
            case AREA: {
                return this.areas();
            }
            case LINE: {
                return this.lines();
            }
            case POINT: {
                return this.points();
            }
            case RELATION: {
                return this.relations();
            }
        }
        throw new CoreException("ItemType {} unknown.", new Object[]{type});
    }

    @Override
    public Iterable<AtlasEntity> entities(Predicate<AtlasEntity> matcher) {
        return Iterables.filter(this, matcher);
    }

    @Override
    public Iterable<AtlasEntity> entitiesIntersecting(Polygon polygon) {
        return new MultiIterable<AtlasEntity>(this.itemsIntersecting(polygon), this.relationsWithEntitiesIntersecting(polygon));
    }

    @Override
    public Iterable<AtlasEntity> entitiesIntersecting(Polygon polygon, Predicate<AtlasEntity> matcher) {
        return Iterables.filter(this.entitiesIntersecting(polygon), matcher);
    }

    @Override
    public AtlasEntity entity(long identifier, ItemType type) {
        switch (type) {
            case NODE: {
                return this.node(identifier);
            }
            case EDGE: {
                return this.edge(identifier);
            }
            case AREA: {
                return this.area(identifier);
            }
            case LINE: {
                return this.line(identifier);
            }
            case POINT: {
                return this.point(identifier);
            }
            case RELATION: {
                return this.relation(identifier);
            }
        }
        throw new CoreException("Unknown type {}", new Object[]{type});
    }

    public boolean equals(Object other) {
        if (other instanceof Atlas) {
            if (this == other) {
                return true;
            }
            Atlas that = (Atlas)other;
            for (AtlasEntity thisEntity : this) {
                AtlasEntity thatEntity = that.entity(thisEntity.getIdentifier(), thisEntity.getType());
                if (thatEntity == null || !thisEntity.getTags().equals(thatEntity.getTags())) {
                    return false;
                }
                if (thisEntity instanceof Area) {
                    Polygon thatPolygon;
                    Polygon thisPolygon = ((Area)thisEntity).asPolygon();
                    if (thisPolygon.equals(thatPolygon = ((Area)thatEntity).asPolygon())) continue;
                    return false;
                }
                if (thisEntity instanceof LineItem) {
                    PolyLine thatPolyLine;
                    PolyLine thisPolyLine = ((LineItem)thisEntity).asPolyLine();
                    if (thisPolyLine.equals(thatPolyLine = ((LineItem)thatEntity).asPolyLine())) continue;
                    return false;
                }
                if (thisEntity instanceof LocationItem) {
                    Location thatLocation;
                    Location thisLocation = ((LocationItem)thisEntity).getLocation();
                    if (thisLocation.equals(thatLocation = ((LocationItem)thatEntity).getLocation())) continue;
                    return false;
                }
                if (thisEntity instanceof Relation) {
                    RelationMemberList thatMembers;
                    RelationMemberList thisMembers = ((Relation)thisEntity).members();
                    if (thisMembers.equals(thatMembers = ((Relation)thatEntity).members())) continue;
                    return false;
                }
                throw new CoreException("Unknown type: {}", thisEntity.getClass().getName());
            }
            return true;
        }
        return false;
    }

    @Override
    public int getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return String.valueOf(this.getIdentifier());
        }
        return this.name;
    }

    public int hashCode() {
        return Long.hashCode(this.numberOfNodes() + this.numberOfEdges() + this.numberOfAreas() + this.numberOfLines() + this.numberOfPoints() + this.numberOfRelations());
    }

    @Override
    public Iterable<AtlasItem> items() {
        return new MultiIterable<AtlasItem>(this.nodes(), this.edges(), this.areas(), this.lines(), this.points());
    }

    @Override
    public Iterable<AtlasItem> items(Predicate<AtlasItem> matcher) {
        return Iterables.filter(this.items(), matcher);
    }

    @Override
    public Iterable<AtlasItem> itemsContaining(Location location) {
        return new MultiIterable<AtlasItem>(this.edgesContaining(location), this.nodesAt(location), this.areasCovering(location), this.linesContaining(location), this.pointsAt(location));
    }

    @Override
    public Iterable<AtlasItem> itemsContaining(Location location, Predicate<AtlasItem> matcher) {
        return Iterables.filter(this.itemsContaining(location), matcher);
    }

    @Override
    public Iterable<AtlasItem> itemsIntersecting(Polygon polygon) {
        return new MultiIterable<AtlasItem>(this.edgesIntersecting(polygon), this.nodesWithin(polygon), this.areasIntersecting(polygon), this.linesIntersecting(polygon), this.pointsWithin(polygon));
    }

    @Override
    public Iterable<AtlasItem> itemsIntersecting(Polygon polygon, Predicate<AtlasItem> matcher) {
        return Iterables.filter(this.itemsIntersecting(polygon), matcher);
    }

    @Override
    public Iterator<AtlasEntity> iterator() {
        return new MultiIterable(this.nodes(), this.edges(), this.areas(), this.lines(), this.points(), this.relations()).iterator();
    }

    @Override
    public Iterable<LineItem> lineItems() {
        return new MultiIterable<LineItem>(this.edges(), this.lines());
    }

    @Override
    public Iterable<LineItem> lineItems(Predicate<LineItem> matcher) {
        return Iterables.filter(this.lineItems(), matcher);
    }

    @Override
    public Iterable<LineItem> lineItemsContaining(Location location) {
        return new MultiIterable<LineItem>(this.edgesContaining(location), this.linesContaining(location));
    }

    @Override
    public Iterable<LineItem> lineItemsContaining(Location location, Predicate<LineItem> matcher) {
        return Iterables.filter(this.lineItemsContaining(location), matcher);
    }

    @Override
    public Iterable<LineItem> lineItemsIntersecting(Polygon polygon) {
        return new MultiIterable<LineItem>(this.edgesIntersecting(polygon), this.linesIntersecting(polygon));
    }

    @Override
    public Iterable<LineItem> lineItemsIntersecting(Polygon polygon, Predicate<LineItem> matcher) {
        return Iterables.filter(this.lineItemsIntersecting(polygon), matcher);
    }

    @Override
    public Iterable<Line> lines(Predicate<Line> matcher) {
        return Iterables.filter(this.lines(), matcher);
    }

    @Override
    public Iterable<LocationItem> locationItems() {
        return new MultiIterable<LocationItem>(this.nodes(), this.points());
    }

    @Override
    public Iterable<LocationItem> locationItems(Predicate<LocationItem> matcher) {
        return Iterables.filter(this.locationItems(), matcher);
    }

    @Override
    public Iterable<LocationItem> locationItemsWithin(Polygon polygon) {
        return new MultiIterable<LocationItem>(this.nodesWithin(polygon), this.pointsWithin(polygon));
    }

    @Override
    public Iterable<LocationItem> locationItemsWithin(Polygon polygon, Predicate<LocationItem> matcher) {
        return Iterables.filter(this.locationItemsWithin(polygon), matcher);
    }

    @Override
    public Iterable<Node> nodes(Predicate<Node> matcher) {
        return Iterables.filter(this.nodes(), matcher);
    }

    @Override
    public Iterable<Point> points(Predicate<Point> matcher) {
        return Iterables.filter(this.points(), matcher);
    }

    @Override
    public Iterable<Relation> relations(Predicate<Relation> matcher) {
        return Iterables.filter(this.relations(), matcher);
    }

    @Override
    public Iterable<Relation> relationsLowerOrderFirst() {
        ArrayList<Relation> stagedRelations = new ArrayList<Relation>();
        LinkedHashSet<Relation> result = new LinkedHashSet<Relation>();
        for (Relation relation : this.relations()) {
            boolean stageable = false;
            RelationMemberList members = relation.members();
            for (RelationMember member : members) {
                if (!(member.getEntity() instanceof Relation)) continue;
                stageable = true;
            }
            if (stageable) {
                stagedRelations.add(relation);
                continue;
            }
            result.add(relation);
        }
        for (int depth = 0; !stagedRelations.isEmpty() && depth < 500; ++depth) {
            ArrayList<Relation> newStagedRelations = new ArrayList<Relation>();
            for (Relation relation : stagedRelations) {
                boolean stageable = false;
                RelationMemberList members = relation.members();
                for (RelationMember member : members) {
                    if (!(member.getEntity() instanceof Relation) || result.contains(member.getEntity())) continue;
                    stageable = true;
                }
                if (stageable) {
                    newStagedRelations.add(relation);
                    continue;
                }
                result.add(relation);
            }
            stagedRelations = newStagedRelations;
        }
        return result;
    }

    @Override
    public void saveAsGeoJson(WritableResource resource) {
        this.saveAsGeoJson(resource, item -> true);
    }

    @Override
    public void saveAsGeoJson(WritableResource resource, Predicate<AtlasEntity> matcher) {
        JsonWriter writer = new JsonWriter(resource);
        writer.write(this.asGeoJson(matcher).jsonObject());
        writer.close();
    }

    @Override
    public void saveAsList(WritableResource resource) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(resource.write(), StandardCharsets.UTF_8));
        try {
            writer.write(this.toString());
            Streams.close(writer);
        }
        catch (IOException e) {
            Streams.close(writer);
            throw new CoreException("Could not save atlas as list", e);
        }
    }

    @Override
    public void saveAsProto(WritableResource resource) {
        new ProtoAtlasBuilder().write(this, resource);
    }

    @Override
    public void saveAsText(WritableResource resource) {
        new TextAtlasBuilder().write(this, resource);
    }

    @Override
    public SnappedEdge snapped(Location point, Distance threshold) {
        SnappedEdge result = null;
        for (Edge edge : this.edgesIntersecting(point.boxAround(threshold))) {
            SnappedEdge candidate = new SnappedEdge(point.snapTo(edge.asPolyLine()), edge);
            if (result != null && !candidate.getDistance().isLessThan(result.getDistance())) continue;
            result = candidate;
        }
        return result;
    }

    @Override
    public SortedSet<SnappedEdge> snaps(Location point, Distance threshold) {
        TreeSet<SnappedEdge> snaps = new TreeSet<SnappedEdge>();
        for (Edge edge : this.edgesIntersecting(point.boxAround(threshold))) {
            SnappedEdge candidate = new SnappedEdge(point.snapTo(edge.asPolyLine()), edge);
            snaps.add(candidate);
        }
        return snaps;
    }

    @Override
    public Optional<Atlas> subAtlas(Polygon boundary) {
        Time begin = Time.now();
        Supplier<Iterable<Node>> nodesWithin = this.getCachingSupplier(this.nodesWithin(boundary), ItemType.NODE);
        Supplier<Iterable<Edge>> edgesIntersecting = this.getCachingSupplier(this.edgesIntersecting(boundary), ItemType.EDGE);
        Supplier<Iterable<Area>> areasIntersecting = this.getCachingSupplier(this.areasIntersecting(boundary), ItemType.AREA);
        Supplier<Iterable<Line>> linesIntersecting = this.getCachingSupplier(this.linesIntersecting(boundary), ItemType.LINE);
        Supplier<Iterable<Point>> pointsWithin = this.getCachingSupplier(this.pointsWithin(boundary), ItemType.POINT);
        double ratioBuffer = 1.2;
        long nodeNumber = Math.round((double)Iterables.size(nodesWithin.get()) * 1.2);
        long edgeNumber = Math.round((double)Iterables.size(edgesIntersecting.get()) * 1.2);
        long areaNumber = Math.round((double)Iterables.size(areasIntersecting.get()) * 1.2);
        long lineNumber = Math.round((double)Iterables.size(linesIntersecting.get()) * 1.2);
        long pointNumber = Math.round((double)Iterables.size(pointsWithin.get()) * 1.2);
        long relationNumber = Math.round((double)Iterables.size(this.relationsWithEntitiesIntersecting(boundary)) * 1.2);
        AtlasSize size = new AtlasSize(edgeNumber, nodeNumber, areaNumber, lineNumber, pointNumber, relationNumber);
        PackedAtlasBuilder builder = new PackedAtlasBuilder().withSizeEstimates(size).withMetaData(this.metaData());
        Predicate<Node> hasNode = item -> builder.peek().node(item.getIdentifier()) != null;
        Predicate<Edge> hasEdge = item -> builder.peek().edge(item.getIdentifier()) != null;
        Predicate<Area> hasArea = item -> builder.peek().area(item.getIdentifier()) != null;
        Predicate<Line> hasLine = item -> builder.peek().line(item.getIdentifier()) != null;
        Predicate<Point> hasPoint = item -> builder.peek().point(item.getIdentifier()) != null;
        Predicate<Relation> hasRelation = item -> builder.peek().relation(item.getIdentifier()) != null;
        edgesIntersecting.get().forEach(edge -> {
            Node start = edge.start();
            Node end = edge.end();
            if (!hasNode.test(start)) {
                builder.addNode(start.getIdentifier(), start.getLocation(), start.getTags());
            }
            if (!hasNode.test(end)) {
                builder.addNode(end.getIdentifier(), end.getLocation(), end.getTags());
            }
        });
        Iterables.stream(nodesWithin.get()).filter(hasNode.negate()).forEach(node -> builder.addNode(node.getIdentifier(), node.getLocation(), node.getTags()));
        Consumer<Edge> edgeAdder = edge -> {
            if (builder.peek().edge(edge.getIdentifier()) == null) {
                if (edge.getIdentifier() != 0L && edge.hasReverseEdge()) {
                    Edge reverse = edge.reversed().get();
                    if (builder.peek().edge(reverse.getIdentifier()) == null) {
                        builder.addEdge(reverse.getIdentifier(), reverse.asPolyLine(), reverse.getTags());
                    }
                }
                builder.addEdge(edge.getIdentifier(), edge.asPolyLine(), edge.getTags());
            }
        };
        edgesIntersecting.get().forEach(edgeAdder::accept);
        areasIntersecting.get().forEach(area -> builder.addArea(area.getIdentifier(), area.asPolygon(), area.getTags()));
        linesIntersecting.get().forEach(line -> builder.addLine(line.getIdentifier(), line.asPolyLine(), line.getTags()));
        pointsWithin.get().forEach(point -> builder.addPoint(point.getIdentifier(), point.getLocation(), point.getTags()));
        ArrayList<Boolean> relationAdded = new ArrayList<Boolean>();
        relationAdded.add(true);
        while (this.numberOfRelations() > Iterables.size(builder.peek().relations()) && ((Boolean)relationAdded.get(0)).booleanValue()) {
            relationAdded.set(0, false);
            Iterables.stream(this.relations()).filter(hasRelation.negate()).forEach(relation -> {
                RelationMemberList members = relation.members();
                ArrayList validMembers = new ArrayList();
                members.forEach(member -> {
                    AtlasEntity entity = member.getEntity();
                    if (entity instanceof Node && hasNode.test((Node)entity) || entity instanceof Edge && hasEdge.test((Edge)entity) || entity instanceof Area && hasArea.test((Area)entity) || entity instanceof Line && hasLine.test((Line)entity) || entity instanceof Point && hasPoint.test((Point)entity)) {
                        validMembers.add(member);
                    }
                    if (entity instanceof Relation && hasRelation.test((Relation)entity)) {
                        relationAdded.set(0, true);
                        validMembers.add(member);
                    }
                });
                if (!validMembers.isEmpty()) {
                    RelationBean structure = new RelationBean();
                    validMembers.forEach(validMember -> structure.addItem(validMember.getEntity().getIdentifier(), validMember.getRole(), ItemType.forEntity(validMember.getEntity())));
                    builder.addRelation(relation.getIdentifier(), relation.getOsmIdentifier(), structure, relation.getTags());
                }
            });
        }
        PackedAtlas result = (PackedAtlas)builder.get();
        if (result != null) {
            result.trim();
        }
        logger.info("Cut sub-atlas in {}", (Object)begin.elapsedSince());
        return Optional.ofNullable(result);
    }

    @Override
    public Optional<Atlas> subAtlas(Predicate<AtlasEntity> matcher) {
        logger.debug("Filtering Atlas {} with meta-data {}", (Object)this.getName(), (Object)this.metaData());
        Time begin = Time.now();
        PackedAtlasBuilder builder = new PackedAtlasBuilder().withSizeEstimates(this.size()).withMetaData(this.metaData()).withName(this.getName() + "_sub");
        for (AtlasEntity atlasEntity : this.relations(matcher::test)) {
            this.indexAllNodesFromRelation((Relation)atlasEntity, builder, 0);
        }
        StreamIterable<AtlasEntity> nodes = Iterables.stream(this.nodes(matcher::test)).map(item -> item);
        StreamIterable<AtlasEntity> streamIterable = Iterables.stream(this.edges(matcher::test)).map(item -> item);
        for (AtlasEntity entity : new MultiIterable(nodes, streamIterable)) {
            this.addNodesToAtlas(entity, builder);
        }
        for (Edge edge : this.edges(matcher::test)) {
            this.indexEdge(edge, builder);
        }
        for (Area area : this.areas(matcher::test)) {
            builder.addArea(area.getIdentifier(), area.asPolygon(), area.getTags());
        }
        for (Line line : this.lines(matcher::test)) {
            builder.addLine(line.getIdentifier(), line.asPolyLine(), line.getTags());
        }
        for (Point point : this.points(matcher::test)) {
            builder.addPoint(point.getIdentifier(), point.getLocation(), point.getTags());
        }
        HashSet<Long> stagedRelationIdentifiers = new HashSet<Long>();
        Iterable<Relation> relations = this.relations(matcher::test);
        for (Relation relation : relations) {
            this.checkRelationMembersAndIndexRelation(relation, matcher, stagedRelationIdentifiers, builder);
        }
        int iterations = 0;
        while (++iterations < 500 && !stagedRelationIdentifiers.isEmpty()) {
            logger.trace("Copying relations level {} deep.", (Object)iterations);
            HashSet<Long> stagedRelationIdentifiersCopy = new HashSet<Long>();
            for (Long relationIdentifier : stagedRelationIdentifiers) {
                Relation relation = this.relation(relationIdentifier);
                this.checkRelationMembersAndIndexRelation(relation, matcher, stagedRelationIdentifiersCopy, builder);
            }
            stagedRelationIdentifiers = stagedRelationIdentifiersCopy;
        }
        if (iterations >= 500) {
            throw new CoreException("There might be a loop in relations! It took more than {} loops to update the relation from atlas {}.", 500, this.getName());
        }
        PackedAtlas result = (PackedAtlas)builder.get();
        if (result != null) {
            result.trim();
        }
        logger.info("Cut sub-atlas in {}", (Object)begin.elapsedSince());
        return Optional.ofNullable(result);
    }

    @Override
    public String summary() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getClass().getSimpleName());
        builder.append(": Nodes = ");
        builder.append(NUMBER_FORMAT.format(this.numberOfNodes()));
        builder.append(", Edges = ");
        builder.append(NUMBER_FORMAT.format(this.numberOfEdges()));
        builder.append(", Areas = ");
        builder.append(NUMBER_FORMAT.format(this.numberOfAreas()));
        builder.append(", Lines = ");
        builder.append(NUMBER_FORMAT.format(this.numberOfLines()));
        builder.append(", Points = ");
        builder.append(NUMBER_FORMAT.format(this.numberOfPoints()));
        builder.append(", Relations = ");
        builder.append(NUMBER_FORMAT.format(this.numberOfRelations()));
        builder.append("]");
        return builder.toString();
    }

    public String toString() {
        String newLineAfterFeature = ",\n\t\t";
        StringBuilder builder = new StringBuilder();
        builder.append("[Atlas <");
        builder.append(this.getName());
        builder.append(">: ");
        StringList list = new StringList();
        list.add(Iterables.toString(this.nodes(), "Nodes", ",\n\t\t"));
        list.add(Iterables.toString(this.edges(), "Edges", ",\n\t\t"));
        list.add(Iterables.toString(this.areas(), "Areas", ",\n\t\t"));
        list.add(Iterables.toString(this.lines(), "Lines", ",\n\t\t"));
        list.add(Iterables.toString(this.points(), "Points", ",\n\t\t"));
        list.add(Iterables.toString(this.relations(), "Relations", ",\n\t\t"));
        builder.append(list.join(",\n\t"));
        builder.append("]");
        return builder.toString();
    }

    protected void setName(String name) {
        this.name = name;
    }

    private void addNodesToAtlas(AtlasEntity entity, PackedAtlasBuilder builder) {
        long identifier = entity.getIdentifier();
        if (entity instanceof Node) {
            Node node = (Node)entity;
            if (builder.peek().node(identifier) == null) {
                builder.addNode(identifier, node.getLocation(), node.getTags());
            }
        } else if (entity instanceof Edge) {
            Edge edge = (Edge)entity;
            Node start = edge.start();
            Node end = edge.end();
            long startIdentifier = start.getIdentifier();
            long endIdentifier = end.getIdentifier();
            if (builder.peek().node(startIdentifier) == null) {
                builder.addNode(startIdentifier, start.getLocation(), start.getTags());
            }
            if (builder.peek().node(endIdentifier) == null) {
                builder.addNode(endIdentifier, end.getLocation(), end.getTags());
            }
        }
    }

    private void checkRelationMembersAndIndexRelation(Relation relation, Predicate<AtlasEntity> matcher, Set<Long> stagedRelationIdentifiers, PackedAtlasBuilder builder) {
        boolean allRelationsMembersAreIndexed = true;
        long relationIdentifier = relation.getIdentifier();
        for (RelationMember member2 : relation.members()) {
            ItemType memberType = member2.getEntity().getType();
            long memberIdentifier = member2.getEntity().getIdentifier();
            switch (memberType) {
                case EDGE: {
                    Edge edgeMember = (Edge)member2.getEntity();
                    this.indexEdge(edgeMember, builder);
                    break;
                }
                case AREA: {
                    Area areaMember = (Area)member2.getEntity();
                    if (builder.peek().area(memberIdentifier) != null) break;
                    builder.addArea(memberIdentifier, areaMember.asPolygon(), areaMember.getTags());
                    break;
                }
                case LINE: {
                    Line lineMember = (Line)member2.getEntity();
                    if (builder.peek().line(memberIdentifier) != null) break;
                    builder.addLine(memberIdentifier, lineMember.asPolyLine(), lineMember.getTags());
                    break;
                }
                case POINT: {
                    Point pointMember = (Point)member2.getEntity();
                    if (builder.peek().point(memberIdentifier) != null) break;
                    builder.addPoint(memberIdentifier, pointMember.getLocation(), pointMember.getTags());
                    break;
                }
                case RELATION: {
                    Relation relationMember = (Relation)member2.getEntity();
                    if (builder.peek().relation(memberIdentifier) != null) break;
                    if (!matcher.test(relationMember)) {
                        stagedRelationIdentifiers.add(memberIdentifier);
                    }
                    stagedRelationIdentifiers.add(relationIdentifier);
                    allRelationsMembersAreIndexed = false;
                    break;
                }
            }
        }
        if (allRelationsMembersAreIndexed && builder.peek().relation(relationIdentifier) == null) {
            RelationBean bean = new RelationBean();
            relation.members().forEach(member -> bean.addItem(member.getEntity().getIdentifier(), member.getRole(), member.getEntity().getType()));
            builder.addRelation(relationIdentifier, relation.getOsmIdentifier(), bean, relation.getTags());
        }
    }

    private <M extends AtlasEntity> Supplier<Iterable<M>> getCachingSupplier(Iterable<M> source, ItemType type) {
        HashSet memberIdentifiersIntersecting = new HashSet();
        Supplier<Iterable<M>> result = () -> {
            if (memberIdentifiersIntersecting.isEmpty()) {
                return Iterables.stream(source).map(member -> {
                    memberIdentifiersIntersecting.add(member.getIdentifier());
                    return member;
                }).collect();
            }
            return Iterables.stream(memberIdentifiersIntersecting).map(entityIdentifier -> this.entity((long)entityIdentifier, type)).collect();
        };
        return result;
    }

    private void indexAllNodesFromRelation(Relation relation, PackedAtlasBuilder builder, int relationDepth) {
        if (relationDepth > 500) {
            throw new CoreException("Relation depth is greater than {} for the relation from atlas {}.", 500, this.getName());
        }
        for (RelationMember member : relation.members()) {
            ItemType type = member.getEntity().getType();
            if (ItemType.NODE == type || ItemType.EDGE == type) {
                this.addNodesToAtlas(member.getEntity(), builder);
                continue;
            }
            if (ItemType.RELATION != type) continue;
            Relation relationMember = (Relation)member.getEntity();
            this.indexAllNodesFromRelation(relationMember, builder, relationDepth + 1);
        }
    }

    private void indexEdge(Edge edge, PackedAtlasBuilder builder) {
        if (builder.peek().edge(edge.getIdentifier()) == null) {
            builder.addEdge(edge.getIdentifier(), edge.asPolyLine(), edge.getTags());
        }
        if (edge.hasReverseEdge()) {
            Edge reverseEdge = edge.reversed().get();
            long reverseEdgeIdentifier = reverseEdge.getIdentifier();
            if (builder.peek().edge(reverseEdgeIdentifier) == null) {
                builder.addEdge(reverseEdgeIdentifier, reverseEdge.asPolyLine(), reverseEdge.getTags());
            }
        }
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(true);
    }
}

