/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography.atlas;

import java.io.Serializable;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Predicate;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.builder.AtlasSize;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.SnappedEdge;
import org.openstreetmap.atlas.geography.geojson.GeoJsonObject;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public interface Atlas
extends Located,
Iterable<AtlasEntity>,
Serializable {
    public Area area(long var1);

    public Iterable<Area> areas();

    public Iterable<Area> areas(Predicate<Area> var1);

    public Iterable<Area> areasCovering(Location var1);

    public Iterable<Area> areasCovering(Location var1, Predicate<Area> var2);

    public Iterable<Area> areasIntersecting(Polygon var1);

    public Iterable<Area> areasIntersecting(Polygon var1, Predicate<Area> var2);

    public GeoJsonObject asGeoJson();

    public GeoJsonObject asGeoJson(Predicate<AtlasEntity> var1);

    public Edge edge(long var1);

    public Iterable<Edge> edges();

    public Iterable<Edge> edges(Predicate<Edge> var1);

    public Iterable<Edge> edgesContaining(Location var1);

    public Iterable<Edge> edgesContaining(Location var1, Predicate<Edge> var2);

    public Iterable<Edge> edgesIntersecting(Polygon var1);

    public Iterable<Edge> edgesIntersecting(Polygon var1, Predicate<Edge> var2);

    public Iterable<AtlasEntity> entities();

    public <M extends AtlasEntity> Iterable<M> entities(ItemType var1, Class<M> var2);

    public Iterable<AtlasEntity> entities(Predicate<AtlasEntity> var1);

    public Iterable<AtlasEntity> entitiesIntersecting(Polygon var1);

    public Iterable<AtlasEntity> entitiesIntersecting(Polygon var1, Predicate<AtlasEntity> var2);

    public AtlasEntity entity(long var1, ItemType var3);

    public int getIdentifier();

    public String getName();

    public Iterable<AtlasItem> items();

    public Iterable<AtlasItem> items(Predicate<AtlasItem> var1);

    public Iterable<AtlasItem> itemsContaining(Location var1);

    public Iterable<AtlasItem> itemsContaining(Location var1, Predicate<AtlasItem> var2);

    public Iterable<AtlasItem> itemsIntersecting(Polygon var1);

    public Iterable<AtlasItem> itemsIntersecting(Polygon var1, Predicate<AtlasItem> var2);

    public Line line(long var1);

    public Iterable<LineItem> lineItems();

    public Iterable<LineItem> lineItems(Predicate<LineItem> var1);

    public Iterable<LineItem> lineItemsContaining(Location var1);

    public Iterable<LineItem> lineItemsContaining(Location var1, Predicate<LineItem> var2);

    public Iterable<LineItem> lineItemsIntersecting(Polygon var1);

    public Iterable<LineItem> lineItemsIntersecting(Polygon var1, Predicate<LineItem> var2);

    public Iterable<Line> lines();

    public Iterable<Line> lines(Predicate<Line> var1);

    public Iterable<Line> linesContaining(Location var1);

    public Iterable<Line> linesContaining(Location var1, Predicate<Line> var2);

    public Iterable<Line> linesIntersecting(Polygon var1);

    public Iterable<Line> linesIntersecting(Polygon var1, Predicate<Line> var2);

    public Iterable<LocationItem> locationItems();

    public Iterable<LocationItem> locationItems(Predicate<LocationItem> var1);

    public Iterable<LocationItem> locationItemsWithin(Polygon var1);

    public Iterable<LocationItem> locationItemsWithin(Polygon var1, Predicate<LocationItem> var2);

    public AtlasMetaData metaData();

    public Node node(long var1);

    public Iterable<Node> nodes();

    public Iterable<Node> nodes(Predicate<Node> var1);

    public Iterable<Node> nodesAt(Location var1);

    public Iterable<Node> nodesWithin(Polygon var1);

    public Iterable<Node> nodesWithin(Polygon var1, Predicate<Node> var2);

    public long numberOfAreas();

    public long numberOfEdges();

    public long numberOfLines();

    public long numberOfNodes();

    public long numberOfPoints();

    public long numberOfRelations();

    public Point point(long var1);

    public Iterable<Point> points();

    public Iterable<Point> points(Predicate<Point> var1);

    public Iterable<Point> pointsAt(Location var1);

    public Iterable<Point> pointsWithin(Polygon var1);

    public Iterable<Point> pointsWithin(Polygon var1, Predicate<Point> var2);

    public Relation relation(long var1);

    public Iterable<Relation> relations();

    public Iterable<Relation> relations(Predicate<Relation> var1);

    public Iterable<Relation> relationsLowerOrderFirst();

    public Iterable<Relation> relationsWithEntitiesIntersecting(Polygon var1);

    public Iterable<Relation> relationsWithEntitiesIntersecting(Polygon var1, Predicate<Relation> var2);

    public void save(WritableResource var1);

    public void saveAsGeoJson(WritableResource var1);

    public void saveAsGeoJson(WritableResource var1, Predicate<AtlasEntity> var2);

    public void saveAsList(WritableResource var1);

    public void saveAsProto(WritableResource var1);

    public void saveAsText(WritableResource var1);

    default public AtlasSize size() {
        return new AtlasSize(this.numberOfEdges(), this.numberOfNodes(), this.numberOfAreas(), this.numberOfLines(), this.numberOfPoints(), this.numberOfRelations());
    }

    public SnappedEdge snapped(Location var1, Distance var2);

    public SortedSet<SnappedEdge> snaps(Location var1, Distance var2);

    public Optional<Atlas> subAtlas(Polygon var1);

    public Optional<Atlas> subAtlas(Predicate<AtlasEntity> var1);

    public String summary();
}

