/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import com.google.common.collect.Iterables;
import org.openstreetmap.atlas.geography.Latitude;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.Longitude;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class Snapper {
    public SnappedLocation snap(Location origin, Iterable<? extends Location> shape) {
        if (shape instanceof Segment) {
            Segment target = (Segment)shape;
            Segment variable = new Segment(target.start(), origin);
            double dotProduct = target.dotProduct(variable);
            if (dotProduct <= 0.0) {
                return new SnappedLocation(origin, target.start(), target);
            }
            if (dotProduct >= target.dotProduct(target)) {
                return new SnappedLocation(origin, target.end(), target);
            }
            double cosAlpha = dotProduct / (target.dotProductLength() * variable.dotProductLength());
            double offsetDistance = cosAlpha * variable.dotProductLength();
            double latitudeAsDm7 = (double)target.start().getLatitude().asDm7() + offsetDistance / target.dotProductLength() * (double)target.latitudeSpan();
            double longitudeAsDm7 = (double)target.start().getLongitude().asDm7() + offsetDistance / target.dotProductLength() * (double)target.longitudeSpan();
            Location snapped = new Location(Latitude.dm7(Math.round(latitudeAsDm7)), Longitude.dm7(Math.round(longitudeAsDm7)));
            return new SnappedLocation(origin, snapped, target);
        }
        if (Iterables.size(shape) > 1) {
            PolyLine target = shape instanceof PolyLine ? (PolyLine)shape : (shape instanceof Polygon ? (Polygon)shape : new PolyLine(shape));
            SnappedLocation best = null;
            for (Segment segment : target.segments()) {
                SnappedLocation candidate = this.snap(origin, segment);
                if (best != null && !candidate.getDistance().isLessThan(best.getDistance())) continue;
                best = candidate;
            }
            return new SnappedLocation(origin, best, target);
        }
        if (Iterables.size(shape) == 1) {
            Location target = shape.iterator().next();
            return new SnappedLocation(origin, target, new PolyLine((Iterable<? extends Location>)target));
        }
        return null;
    }

    public SnappedLocation snap(Location origin, MultiPolygon shape) {
        SnappedLocation best = null;
        for (Polygon member : new MultiIterable(shape.outers(), shape.inners())) {
            SnappedLocation candidate = this.snap(origin, member);
            if (best != null && !candidate.getDistance().isLessThan(best.getDistance())) continue;
            best = candidate;
        }
        return best;
    }

    public static class SnappedLocation
    extends Location
    implements Comparable<SnappedLocation> {
        private static final long serialVersionUID = -3283158797347353372L;
        private final Location origin;
        private final PolyLine target;

        public SnappedLocation(Location origin, Location snapped, PolyLine target) {
            super(snapped.asConcatenation());
            this.origin = origin;
            this.target = target;
        }

        @Override
        public int compareTo(SnappedLocation other) {
            return this.getDistance().isLessThan(other.getDistance()) ? -1 : (this.getDistance().equals(other.getDistance()) ? 0 : 1);
        }

        public Distance getDistance() {
            return this.origin.distanceTo(this);
        }

        public Location getOrigin() {
            return this.origin;
        }

        public PolyLine getTarget() {
            return this.target;
        }
    }
}

