/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.geography;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.converters.WktMultiPolyLineConverter;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.utilities.collections.Iterables;

public class MultiPolyLine
implements Iterable<PolyLine>,
Located,
Serializable {
    private static final long serialVersionUID = 5907807607388840698L;
    private final List<PolyLine> polyLineList;

    public static MultiPolyLine wkt(String wkt) {
        return new WktMultiPolyLineConverter().backwardConvert(wkt);
    }

    public MultiPolyLine(Iterable<? extends PolyLine> polyLines) {
        this(Iterables.asList(polyLines));
    }

    public MultiPolyLine(List<? extends PolyLine> polyLines) {
        if (polyLines.isEmpty()) {
            throw new CoreException("Cannot have an empty list of PolyLine or Polygon.");
        }
        this.polyLineList = new ArrayList<PolyLine>(polyLines);
    }

    public MultiPolyLine(PolyLine ... polyLines) {
        this(Iterables.iterable(polyLines));
    }

    public Iterable<GeoJsonBuilder.LocationIterableProperties> asLocationIterableProperties() {
        return this.polyLineList.stream().map(polyLine -> new GeoJsonBuilder.LocationIterableProperties((Iterable<Location>)polyLine, (Map<String, String>)new HashMap<String, String>())).collect(Collectors.toList());
    }

    @Override
    public Rectangle bounds() {
        ArrayList<Location> locations = Lists.newArrayList();
        this.polyLineList.stream().map(PolyLine::getPoints).forEach(locations::addAll);
        return Rectangle.forLocations(locations);
    }

    @Override
    public Iterator<PolyLine> iterator() {
        return this.polyLineList.iterator();
    }
}

