/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.creator;

import java.util.Collections;
import java.util.HashMap;
import org.openstreetmap.atlas.generator.PbfContext;
import org.openstreetmap.atlas.generator.PbfLoader;
import org.openstreetmap.atlas.generator.PbfLocator;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.generator.sharding.AtlasSharding;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class AtlasCreator
extends Command {
    public static final Command.Switch<CountryBoundaryMap> BOUNDARIES = new Command.Switch("boundaries", "The boundary map to use", value -> CountryBoundaryMap.fromPlainText(new File((String)value)), Command.Optionality.REQUIRED);
    public static final Command.Switch<String> COUNTRY = new Command.Switch<String>("country", "The country code", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<File> OUTPUT = new Command.Switch("output", "The path where the output will be saved", value -> {
        File result = new File((String)value);
        result.mkdirs();
        return result;
    }, Command.Optionality.REQUIRED);
    public static final Command.Switch<String> PBF_PATH = new Command.Switch<String>("pbfs", "The path to PBFs", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<SlippyTilePersistenceScheme> PBF_SCHEME = new Command.Switch("pbfScheme", "The folder structure of the PBF", SlippyTilePersistenceScheme::new, Command.Optionality.OPTIONAL, PbfLocator.DEFAULT_SCHEME);
    public static final Command.Switch<String> PBF_SHARDING = new Command.Switch<String>("pbfSharding", "The sharding tree of the pbf files. If not specified, this will default to the general Atlas sharding.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> SHARDING_TYPE = new Command.Switch<String>("sharding", "The sharding definition.", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<Shard> TILE = new Command.Switch("tile", "The SlippyTile name to use", SlippyTile::forName, Command.Optionality.REQUIRED);

    public static void main(String[] args) {
        new AtlasCreator().run(args);
    }

    public Atlas generateAtlas(CountryBoundaryMap map, Shard tile, String pbfPath, SlippyTilePersistenceScheme pbfScheme, Sharding pbfSharding, Sharding sharding, String countryName) {
        PbfContext pbfContext = new PbfContext(pbfPath, pbfSharding, pbfScheme);
        PbfLoader loader = new PbfLoader(pbfContext, new HashMap<String, String>(), map, AtlasLoadingOption.createOptionWithAllEnabled(map).setAdditionalCountryCodes(countryName), "dummyCodeVersion", "dummyDataVersion", Collections.emptySet());
        return loader.load(countryName, tile);
    }

    @Override
    protected int onRun(CommandMap command) {
        CountryBoundaryMap map = (CountryBoundaryMap)command.get(BOUNDARIES);
        Shard tile = (Shard)command.get(TILE);
        String pbfPath = (String)command.get(PBF_PATH);
        SlippyTilePersistenceScheme pbfScheme = (SlippyTilePersistenceScheme)command.get(PBF_SCHEME);
        String pbfShardingName = (String)command.get(PBF_SHARDING);
        String shardingName = (String)command.get(SHARDING_TYPE);
        Sharding sharding = AtlasSharding.forString(shardingName, Maps.stringMap(new String[0]));
        Sharding pbfSharding = pbfShardingName != null ? AtlasSharding.forString(shardingName, Maps.stringMap(new String[0])) : sharding;
        String countryName = (String)command.get(COUNTRY);
        File output = (File)command.get(OUTPUT);
        PbfLoader.setAtlasSaveFolder(output);
        Atlas atlas = this.generateAtlas(map, tile, pbfPath, pbfScheme, pbfSharding, sharding, countryName);
        atlas.save(output.child(countryName + "_" + tile.getName() + (Object)((Object)FileSuffix.ATLAS)));
        atlas.saveAsGeoJson(output.child(countryName + "_" + tile.getName() + ".geojson"));
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(BOUNDARIES, TILE, SHARDING_TYPE, PBF_PATH, PBF_SCHEME, PBF_SHARDING, COUNTRY, OUTPUT);
    }
}

