/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.generator.PbfContext;
import org.openstreetmap.atlas.generator.PbfLocator;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.OsmPbfLoader;
import org.openstreetmap.atlas.geography.atlas.raw.creation.RawAtlasGenerator;
import org.openstreetmap.atlas.geography.boundary.CountryBoundary;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.clipping.Clip;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PbfLoader
implements Serializable {
    private static final long serialVersionUID = -3991330796225288845L;
    private static final Logger logger = LoggerFactory.getLogger(PbfLoader.class);
    private static File ATLAS_SAVE_FOLDER;
    private final CountryBoundaryMap boundaries;
    private final PbfLocator locator;
    private final AtlasLoadingOption atlasLoadingOption;
    private final String codeVersion;
    private final String dataVersion;
    private final Set<Shard> countryShards;

    public static void setAtlasSaveFolder(File atlasSaveFolder) {
        ATLAS_SAVE_FOLDER = atlasSaveFolder;
    }

    public PbfLoader(PbfContext pbfContext, Map<String, String> sparkContext, CountryBoundaryMap boundaries, AtlasLoadingOption atlasLoadingOption, String codeVersion, String dataVersion, Set<Shard> countryShards) {
        this.boundaries = boundaries;
        this.atlasLoadingOption = atlasLoadingOption;
        atlasLoadingOption.setCountryBoundaryMap(boundaries);
        this.locator = new PbfLocator(pbfContext, sparkContext);
        this.codeVersion = codeVersion;
        this.dataVersion = dataVersion;
        this.countryShards = countryShards;
    }

    public Atlas generateRawAtlas(String countryName, Shard shard) {
        Optional<MultiPolygon> loadingArea = this.calculateLoadingArea(countryName, shard);
        if (loadingArea.isPresent()) {
            Iterable<PbfLocator.LocatedPbf> pbfPool = this.locator.pbfsCovering(loadingArea.get());
            ArrayList<Atlas> atlases = new ArrayList<Atlas>();
            Map<String, String> metaDataTags = Maps.hashMap(new String[0]);
            metaDataTags.put("countryShards", this.countryShards.stream().map(countryShard -> countryName + "_" + countryShard.getName()).collect(Collectors.joining(",")));
            metaDataTags.put(shard.getName() + "_boundary", loadingArea.toString());
            pbfPool.forEach(locatedPbf -> {
                MultiPolygon pbfLoadingArea = locatedPbf.bounds().clip((MultiPolygon)loadingArea.get(), Clip.ClipType.AND).getClipMultiPolygon();
                if (!pbfLoadingArea.isEmpty()) {
                    AtlasMetaData metaData = new AtlasMetaData(null, true, this.codeVersion, this.dataVersion, countryName, shard.getName(), metaDataTags);
                    Atlas shardPbfSlice = null;
                    try {
                        shardPbfSlice = new RawAtlasGenerator(locatedPbf.getResource(), pbfLoadingArea).withMetaData(metaData).build();
                    }
                    catch (Exception e) {
                        logger.error("Dropping PBF {} for Atlas shard {}", new Object[]{locatedPbf.getResource().getName(), shard, e});
                    }
                    if (shardPbfSlice != null) {
                        atlases.add(shardPbfSlice);
                    }
                }
            });
            if (ATLAS_SAVE_FOLDER != null) {
                int index = 0;
                for (Atlas atlas : atlases) {
                    atlas.save(ATLAS_SAVE_FOLDER.child(shard.getName() + "_" + index++ + ".atlas.gz"));
                }
            }
            if (atlases.size() > 1) {
                logger.info("Concatenating {} PBF-made Atlas into one Atlas Shard {}", (Object)atlases.size(), (Object)shard);
                return PackedAtlas.cloneFrom(new MultiAtlas((List<Atlas>)atlases));
            }
            if (atlases.size() == 1) {
                return (Atlas)atlases.get(0);
            }
            return null;
        }
        return null;
    }

    public Atlas load(String countryName, Shard shard) {
        Optional<MultiPolygon> loadingArea = this.calculateLoadingArea(countryName, shard);
        if (loadingArea.isPresent()) {
            Iterable<PbfLocator.LocatedPbf> pbfPool = this.locator.pbfsCovering(loadingArea.get());
            return this.loadFromPool(pbfPool, loadingArea.get(), countryName, shard);
        }
        return null;
    }

    private Optional<MultiPolygon> calculateLoadingArea(String countryName, Shard shard) {
        List<CountryBoundary> countryBoundaries = this.boundaries.countryBoundary(countryName);
        MultiPolygon boundary = null;
        for (CountryBoundary countryBoundary : countryBoundaries) {
            if (!countryBoundary.covers(shard.bounds())) continue;
            boundary = countryBoundary.getBoundary();
            break;
        }
        if (boundary != null) {
            return Optional.of(shard.bounds().clip(boundary, Clip.ClipType.AND).getClipMultiPolygon());
        }
        logger.error("Can't find shard {} for country {}", (Object)shard, (Object)countryName);
        return Optional.empty();
    }

    private Atlas loadFromPool(Iterable<PbfLocator.LocatedPbf> pbfs, MultiPolygon loadingArea, String country, Shard shard) {
        ArrayList<Atlas> atlases = new ArrayList<Atlas>();
        Map<String, String> metaDataTags = Maps.hashMap(new String[0]);
        metaDataTags.put("countryShards", this.countryShards.stream().map(countryShard -> country + "_" + countryShard.getName()).collect(Collectors.joining(",")));
        metaDataTags.put(shard.getName() + "_boundary", loadingArea.toString());
        pbfs.forEach(locatedPbf -> {
            MultiPolygon pbfLoadingArea = locatedPbf.bounds().clip(loadingArea, Clip.ClipType.AND).getClipMultiPolygon();
            AtlasMetaData metaData = new AtlasMetaData(null, true, this.codeVersion, this.dataVersion, country, shard.getName(), metaDataTags);
            OsmPbfLoader loader = new OsmPbfLoader(locatedPbf.getResource(), pbfLoadingArea, this.atlasLoadingOption).withMetaData(metaData);
            Atlas shardPbfSlice = null;
            try {
                shardPbfSlice = loader.read();
            }
            catch (Exception e) {
                logger.error("Dropping PBF {} for Atlas shard {}", new Object[]{locatedPbf.getResource().getName(), shard, e});
            }
            if (shardPbfSlice != null) {
                atlases.add(shardPbfSlice);
            }
        });
        if (ATLAS_SAVE_FOLDER != null) {
            int index = 0;
            for (Atlas atlas : atlases) {
                atlas.save(ATLAS_SAVE_FOLDER.child(shard.getName() + "_" + index++ + ".atlas.gz"));
            }
        }
        if (atlases.size() > 1) {
            logger.info("Concatenating {} PBF-made Atlas into one Atlas Shard {}", (Object)atlases.size(), (Object)shard);
            return PackedAtlas.cloneFrom(new MultiAtlas((List<Atlas>)atlases));
        }
        if (atlases.size() == 1) {
            return (Atlas)atlases.get(0);
        }
        return null;
    }
}

