/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.directory.api.util.Strings;
import org.openstreetmap.atlas.checks.atlas.predicates.TypePredicates;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class SignPostCheck
extends BaseCheck<String> {
    private static final long serialVersionUID = 8042255121118115024L;
    private static final String NODE_INSTRUCTION = "Junction node {0,number,#} is missing the following tags: {1}.";
    private static final String EDGE_INSTRUCTION = "Way {0,number,#} ({1}) is missing the following tags: {2}.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Junction node {0,number,#} is missing the following tags: {1}.", "Way {0,number,#} ({1}) is missing the following tags: {2}.");
    private static final String OFF_RAMP_KEY = "off-ramp";
    private static final String ON_RAMP_KEY = "on-ramp";
    private static final double DISTANCE_MINIMUM_METERS_DEFAULT = 50.0;
    private static final String SOURCE_EDGE_FILTER_DEFAULT = "highway->motorway,trunk";
    private static final String RAMP_FILTER_DEFAULT = "highway->motorway_link,trunk_link";
    private static final String DESTINATION_TAG_FILTER_DEFAULT = "destination->*|destination:ref->*|destination:street->*";
    private static final String ARTERIAL_MINIMUM_DEFAULT = HighwayTag.RESIDENTIAL.toString();
    private static final long MAX_EDGE_COUNT_FOR_RAMP_DEFAULT = 5L;
    private final long maxEdgeCountForRamp;
    private final Distance minimumLinkLength;
    private final TaggableFilter sourceEdgeFilter;
    private final TaggableFilter rampEdgeFilter;
    private final TaggableFilter destinationTagFilter;
    private final String rampDifferentiatorTag;
    private final HighwayTag arterialMinimum;

    public SignPostCheck(Configuration configuration) {
        super(configuration);
        this.maxEdgeCountForRamp = this.configurationValue(configuration, "ramp.max.edges", 5L);
        this.minimumLinkLength = this.configurationValue(configuration, "linkLength.minimum.meters", 50.0, Distance::meters);
        this.sourceEdgeFilter = this.configurationValue(configuration, "source.filter", SOURCE_EDGE_FILTER_DEFAULT, value -> TaggableFilter.forDefinition(value));
        this.rampEdgeFilter = this.configurationValue(configuration, "ramp.filter", RAMP_FILTER_DEFAULT, value -> TaggableFilter.forDefinition(value));
        this.destinationTagFilter = this.configurationValue(configuration, "destination_tag.filter", DESTINATION_TAG_FILTER_DEFAULT, value -> TaggableFilter.forDefinition(value));
        this.rampDifferentiatorTag = this.configurationValue(configuration, "ramp.differentiator.tag", null);
        this.arterialMinimum = Enum.valueOf(HighwayTag.class, this.configurationValue(configuration, "arterial.minimum", ARTERIAL_MINIMUM_DEFAULT).toUpperCase());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TypePredicates.IS_EDGE.test(object) && this.sourceEdgeFilter.test(object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        HighwayTag highwayTag = edge.highwayTag();
        CheckFlag flag = new CheckFlag(this.getTaskIdentifier(object));
        edge.end().outEdges().stream().filter(connectedEdge -> this.isPossiblyRamp(edge, highwayTag, (Edge)connectedEdge)).forEach(outEdge -> {
            Node start = outEdge.start();
            if (!Validators.isOfType((Taggable)start, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.MOTORWAY_JUNCTION})) {
                flag.addInstruction(this.getLocalizedInstruction(0, start.getOsmIdentifier(), String.format("%s=%s", "highway", HighwayTag.MOTORWAY_JUNCTION.getTagValue())));
                flag.addObject(start);
            }
            if (!this.destinationTagFilter.test((Taggable)outEdge)) {
                flag.addInstruction(this.getLocalizedInstruction(1, outEdge.getOsmIdentifier(), OFF_RAMP_KEY, "destination"));
                flag.addObject((AtlasObject)outEdge);
            }
        });
        edge.start().inEdges().stream().filter(connectedEdge -> this.isPossiblyRamp(edge, highwayTag, (Edge)connectedEdge)).forEach(inEdge -> {
            List<Edge> rampEdgeList = this.findFirstRampEdge((Edge)inEdge, this.maxEdgeCountForRamp);
            for (Edge rampEdge : rampEdgeList) {
                if (this.destinationTagFilter.test(rampEdge)) continue;
                flag.addInstruction(this.getLocalizedInstruction(1, rampEdge.getOsmIdentifier(), ON_RAMP_KEY, "destination"));
                flag.addObject(rampEdge);
            }
        });
        if (!flag.getFlaggedObjects().isEmpty()) {
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private List<Edge> findFirstRampEdge(Edge finalEdge, long maxEdgeCount) {
        Set<Edge> inEdges;
        ArrayList<Edge> endEdges = new ArrayList<Edge>();
        if (maxEdgeCount > 0L && !(inEdges = finalEdge.inEdges()).isEmpty()) {
            for (Edge nextEdge : inEdges) {
                if (this.sourceEdgeFilter.test(nextEdge)) {
                    endEdges.clear();
                    return endEdges;
                }
                if (!this.rampEdgeFilter.test(nextEdge) && HighwayTag.highwayTag(nextEdge).orElse(HighwayTag.NO).isMoreImportantThanOrEqualTo(this.arterialMinimum)) {
                    endEdges.clear();
                    endEdges.add(finalEdge);
                    return endEdges;
                }
                if (!nextEdge.highwayTag().isIdenticalClassification(finalEdge.highwayTag()) || finalEdge.getMasterEdgeIdentifier() == nextEdge.getMasterEdgeIdentifier()) continue;
                endEdges.addAll(this.findFirstRampEdge(nextEdge, maxEdgeCount - 1L));
            }
            return endEdges;
        }
        endEdges.clear();
        endEdges.add(finalEdge);
        return endEdges;
    }

    private boolean isPossiblyRamp(Edge sourceEdge, HighwayTag sourceHighwayTag, Edge connectedEdge) {
        if (!this.rampEdgeFilter.test(connectedEdge) || !connectedEdge.length().isGreaterThan(this.minimumLinkLength)) {
            return false;
        }
        if (!sourceHighwayTag.isIdenticalClassification(connectedEdge.highwayTag())) {
            return true;
        }
        if (this.rampDifferentiatorTag == null) {
            return true;
        }
        String sourceTag = sourceEdge.tag(this.rampDifferentiatorTag);
        String rampTag = connectedEdge.tag(this.rampDifferentiatorTag);
        return (sourceTag != null || rampTag != null) && !Strings.equals((String)sourceTag, (String)rampTag);
    }
}

