/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.linear.edges;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class DuplicateWaysCheck
extends BaseCheck {
    private static final long serialVersionUID = 1L;
    private static final String DUPLICATE_EDGE_INSTRUCTIONS = "This way, {0,number,#}, has at least one duplicate segment.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This way, {0,number,#}, has at least one duplicate segment.");
    private static final Distance ZERO_DISTANCE = Distance.ZERO;

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    public DuplicateWaysCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Edge && Edge.isMasterEdgeIdentifier(object.getIdentifier()) && !this.isFlagged(object.getIdentifier()) && HighwayTag.isCarNavigableHighway(object) && !object.getTag("area").isPresent();
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Edge edge = (Edge)object;
        PolyLine edgePoly = edge.asPolyLine();
        Rectangle bounds = edge.asPolyLine().bounds();
        Iterable<Edge> edgesInBounds = edge.getAtlas().edgesIntersecting(bounds, Edge::isMasterEdge);
        for (Edge edgeInBounds : edgesInBounds) {
            PolyLine subsetEdge;
            if (edgeInBounds.getTag("area").isPresent() || edgeInBounds.asPolyLine().length().equals(ZERO_DISTANCE) || this.isFlagged(edgeInBounds.getIdentifier()) || edge.getIdentifier() == edgeInBounds.getIdentifier()) continue;
            PolyLine edgeInBoundsPoly = edgeInBounds.asPolyLine();
            PolyLine longerEdge = edgePoly.length().isGreaterThan(edgeInBoundsPoly.length()) ? edgePoly : edgeInBoundsPoly;
            if (!longerEdge.overlapsShapeOf(subsetEdge = longerEdge == edgePoly ? edgeInBoundsPoly : edgePoly)) continue;
            this.markAsFlagged(edgeInBounds.getIdentifier());
            return Optional.of(this.createFlag(edgeInBounds, this.getLocalizedInstruction(0, edgeInBounds.getOsmIdentifier())));
        }
        return Optional.empty();
    }
}

