/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.areas;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.tags.AreaTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class AreasWithHighwayTagCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Area with OSM ID {0,number,#} contains invalid highway tag.", "Area with OSM ID {0,number,#} is missing area tag.");
    private static final long serialVersionUID = 3638306611072651348L;

    public AreasWithHighwayTagCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Area;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Area area = (Area)object;
        Optional<String> highwayTag = area.getTag("highway");
        if (highwayTag.isPresent()) {
            int localizedInstruction = Validators.isOfType((Taggable)area, HighwayTag.class, (Enum[])new HighwayTag[]{HighwayTag.PEDESTRIAN}) && !Validators.isOfType((Taggable)area, AreaTag.class, (Enum[])new AreaTag[]{AreaTag.YES}) ? 1 : 0;
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(localizedInstruction, object.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

