/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.maproulette;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRouletteConfiguration
implements Serializable {
    private static final int API_KEY_INDEX = 3;
    private static final int NUMBER_OF_COMPONENTS = 4;
    private static final int PORT_INDEX = 1;
    private static final int PROJECT_NAME_INDEX = 2;
    private static final int SERVER_INDEX = 0;
    private static final Logger logger = LoggerFactory.getLogger(MapRouletteConfiguration.class);
    private static final long serialVersionUID = -1060265212173405828L;
    private final String apiKey;
    private final int port;
    private final String projectName;
    private final String server;

    public static MapRouletteConfiguration parse(String configuration) {
        String[] components;
        if (StringUtils.isNotEmpty(configuration) && (components = configuration.split(":")).length == 4) {
            return new MapRouletteConfiguration(components[0], Integer.parseInt(components[1]), components[2], components[3]);
        }
        logger.debug(String.format("Map Roulette configuration not set, invalid string passed in. [%s]", configuration));
        return null;
    }

    public MapRouletteConfiguration(String server, int port, String projectName, String apiKey) {
        this.server = server;
        this.port = port;
        this.projectName = projectName;
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getPort() {
        return this.port;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getServer() {
        return this.server;
    }

    public String toString() {
        return String.format("%s:%d:%s:%s", this.server, this.port, this.projectName, this.apiKey);
    }
}

