/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.flag;

import com.google.gson.JsonArray;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.atlas.checks.flag.FlaggedObject;
import org.openstreetmap.atlas.checks.flag.FlaggedPoint;
import org.openstreetmap.atlas.checks.flag.FlaggedPolyline;
import org.openstreetmap.atlas.checks.maproulette.data.Task;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.geojson.GeoJsonBuilder;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;

public class CheckFlag
implements Iterable<Location>,
Located,
Serializable {
    private static final long serialVersionUID = -1287808902452203852L;
    private final String identifier;
    private String challengeName = null;
    private final List<String> instructions = new ArrayList<String>();
    private final Set<FlaggedObject> flaggedObjects = new HashSet<FlaggedObject>();

    public CheckFlag(String identifier) {
        this.identifier = identifier;
    }

    public CheckFlag(String identifier, Set<AtlasObject> objects, List<String> instructions) {
        this(identifier, objects, instructions, new ArrayList<Location>());
    }

    public CheckFlag(String identifier, Set<AtlasObject> objects, List<String> instructions, List<Location> points) {
        this.addObjects(objects);
        this.addPoints(points);
        this.addInstructions(instructions);
        this.identifier = identifier;
    }

    public void addInstruction(String instruction) {
        if (StringUtils.isNotEmpty(instruction)) {
            this.instructions.add(instruction);
        }
    }

    public void addInstructions(Iterable<String> instructions) {
        instructions.forEach(this::addInstruction);
    }

    public void addObject(AtlasObject object) {
        if (object instanceof AtlasItem) {
            if (object instanceof LocationItem) {
                this.flaggedObjects.add(new FlaggedPoint((LocationItem)object));
            } else {
                this.flaggedObjects.add(new FlaggedPolyline(object));
            }
        }
    }

    public void addObject(AtlasObject object, Location point, String instruction) {
        this.addObject(object);
        this.addPoint(point);
        this.addInstruction(instruction);
    }

    public void addObject(AtlasObject object, String instruction) {
        this.addObject(object);
        this.addInstruction(instruction);
    }

    public void addObjects(Iterable<AtlasObject> objects) {
        Iterables.stream(objects).forEach(this::addObject);
    }

    public void addPoint(Location point) {
        this.flaggedObjects.add(new FlaggedPoint(point));
    }

    public void addPoints(Iterable<Location> points) {
        Iterables.stream(points).map(FlaggedPoint::new).forEach(this.flaggedObjects::add);
    }

    @Override
    public Rectangle bounds() {
        return Rectangle.forLocated(new MultiIterable<Location>(this.getShapes()));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CheckFlag)) {
            return false;
        }
        CheckFlag otherFlag = (CheckFlag)other;
        return Objects.equals(this.identifier, otherFlag.identifier) && Objects.equals(this.challengeName, otherFlag.challengeName) && Objects.equals(this.instructions, otherFlag.instructions) && Objects.equals(this.flaggedObjects, otherFlag.flaggedObjects);
    }

    public Optional<String> getChallengeName() {
        return Optional.ofNullable(this.challengeName);
    }

    public String getCountryISO() {
        for (FlaggedObject object : this.flaggedObjects) {
            if (!object.hasCountry()) continue;
            return object.getCountry();
        }
        return "NA";
    }

    public Set<FlaggedObject> getFlaggedObjects() {
        return this.flaggedObjects;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getInstructions() {
        StringBuilder builder = new StringBuilder();
        int instructionNumber = 1;
        for (String instruction : this.instructions) {
            if (!StringUtils.isNotEmpty(instruction)) continue;
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(instructionNumber++ + ". " + instruction);
        }
        return builder.toString();
    }

    public List<GeoJsonBuilder.LocationIterableProperties> getLocationIterableProperties() {
        return this.flaggedObjects.stream().map(flaggedObject -> new GeoJsonBuilder.LocationIterableProperties(flaggedObject.getGeometry(), flaggedObject.getProperties())).collect(Collectors.toList());
    }

    public Task getMapRouletteTask() {
        Task task = new Task();
        task.setInstruction(this.getInstructions());
        task.setProjectName(this.getCountryISO());
        task.setChallengeName(this.getChallengeName().orElse(this.getClass().getSimpleName()));
        task.setTaskIdentifier(this.identifier);
        Set<Location> points = this.getPoints();
        if (!points.isEmpty()) {
            task.setPoints(points);
        } else {
            Set<PolyLine> polyLines = this.getPolyLines();
            if (!polyLines.isEmpty()) {
                task.setPoint(polyLines.iterator().next().iterator().next());
            }
        }
        JsonArray features = new JsonArray();
        this.getLocationIterableProperties().forEach(shape -> features.add(new GeoJsonBuilder().create((GeoJsonBuilder.LocationIterableProperties)shape)));
        task.setGeoJson(Optional.of(features));
        return task;
    }

    public Set<Location> getPoints() {
        return this.flaggedObjects.stream().map(FlaggedObject::getGeometry).filter(geometry -> geometry instanceof Location).map(geometry -> (Location)geometry).collect(Collectors.toSet());
    }

    public Set<PolyLine> getPolyLines() {
        return this.flaggedObjects.stream().map(FlaggedObject::getGeometry).filter(geometry -> geometry instanceof PolyLine).map(geometry -> (PolyLine)geometry).collect(Collectors.toSet());
    }

    public Iterable<Iterable<Location>> getShapes() {
        return Iterables.asIterable(this.getPolyLines().stream().map(polyLine -> polyLine).collect(Collectors.toList()));
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.challengeName, this.instructions, this.flaggedObjects);
    }

    @Override
    public Iterator<Location> iterator() {
        return new MultiIterable<Location>(this.getShapes()).iterator();
    }

    public void save(WritableResource writableResource) {
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(writableResource.write(), StandardCharsets.UTF_8));){
            out.write(this.toString());
        }
        catch (Exception e) {
            throw new CoreException("Could not save Check Flag to {}", (Throwable)e, writableResource);
        }
    }

    public void setChallengeName(String challengeName) {
        this.challengeName = challengeName;
    }

    public String toString() {
        return String.format("[CheckFlag: %s, %s]", this.identifier, this.getInstructions());
    }
}

