/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.AbstractSearchFilterVisitor;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.util.Converters;
import org.geotools.util.Utilities;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.And;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class Filters {
    public static final int NOTFOUND = -1;
    private static Filters STATIC = new Filters();
    private static final boolean STRICT = false;
    FilterFactory2 ff;

    public Filters() {
        this(CommonFactoryFinder.getFilterFactory2(null));
    }

    public Filters(FilterFactory2 factory) {
        this.ff = factory;
    }

    public void setFilterFactory(FilterFactory2 factory) {
        this.ff = factory;
    }

    public static Filter and(FilterFactory ff, Filter filter1, Filter filter2) {
        ArrayList<Filter> list = new ArrayList<Filter>(2);
        if (filter1 != null) {
            if (filter1 instanceof And) {
                And some = (And)filter1;
                list.addAll(some.getChildren());
            } else {
                list.add(filter1);
            }
        }
        if (filter2 != null) {
            if (filter2 instanceof And) {
                And more = (And)filter2;
                list.addAll(more.getChildren());
            } else {
                list.add(filter2);
            }
        }
        if (list.size() == 0) {
            return Filter.EXCLUDE;
        }
        if (list.size() == 1) {
            return (Filter)list.get(0);
        }
        return ff.and(list);
    }

    public static Filter or(FilterFactory ff, Filter filter1, Filter filter2) {
        ArrayList<Filter> list = new ArrayList<Filter>();
        if (filter1 != null) {
            if (filter1 instanceof Or) {
                Or some = (Or)filter1;
                list.addAll(some.getChildren());
            } else {
                list.add(filter1);
            }
        }
        if (filter2 != null) {
            if (filter2 instanceof Or) {
                Or more = (Or)filter2;
                list.addAll(more.getChildren());
            } else {
                list.add(filter2);
            }
        }
        if (list.size() == 0) {
            return Filter.EXCLUDE;
        }
        if (list.size() == 1) {
            return (Filter)list.get(0);
        }
        return ff.or(list);
    }

    public Filter duplicate(Filter filter) {
        DuplicatingFilterVisitor xerox = new DuplicatingFilterVisitor(this.ff);
        Filter copy = (Filter)filter.accept(xerox, this.ff);
        return copy;
    }

    public static short getExpressionType(Expression experssion) {
        if (experssion == null) {
            return 0;
        }
        if (experssion instanceof PropertyName) {
            return 113;
        }
        if (experssion instanceof Function) {
            return 114;
        }
        if (experssion instanceof Literal) {
            Literal literal = (Literal)experssion;
            Object value = literal.getValue();
            if (value == null) {
                return 115;
            }
            if (value instanceof Double) {
                return 101;
            }
            if (value instanceof Integer) {
                return 102;
            }
            if (value instanceof Long) {
                return 99;
            }
            if (value instanceof String) {
                return 103;
            }
            if (value instanceof Geometry) {
                return 104;
            }
            if (value instanceof Envelope) {
                return 104;
            }
            return 115;
        }
        if (experssion instanceof Add) {
            return 105;
        }
        if (experssion instanceof Divide) {
            return 108;
        }
        if (experssion instanceof Multiply) {
            return 107;
        }
        if (experssion instanceof Subtract) {
            return 106;
        }
        return 0;
    }

    public static short getFilterType(Filter filter) {
        if (filter == null) {
            return 0;
        }
        if (filter == Filter.EXCLUDE) {
            return -12345;
        }
        if (filter == Filter.INCLUDE) {
            return 12345;
        }
        if (filter instanceof PropertyIsBetween) {
            return 19;
        }
        if (filter instanceof PropertyIsEqualTo) {
            return 14;
        }
        if (filter instanceof PropertyIsGreaterThan) {
            return 16;
        }
        if (filter instanceof PropertyIsGreaterThanOrEqualTo) {
            return 18;
        }
        if (filter instanceof PropertyIsLessThan) {
            return 15;
        }
        if (filter instanceof PropertyIsLessThanOrEqualTo) {
            return 17;
        }
        if (filter instanceof PropertyIsNotEqualTo) {
            return 23;
        }
        if (filter instanceof Id) {
            return 22;
        }
        if (filter instanceof BBOX) {
            return 4;
        }
        if (filter instanceof Beyond) {
            return 13;
        }
        if (filter instanceof Contains) {
            return 11;
        }
        if (filter instanceof Crosses) {
            return 9;
        }
        if (filter instanceof Disjoint) {
            return 6;
        }
        if (filter instanceof DWithin) {
            return 24;
        }
        if (filter instanceof Equals) {
            return 5;
        }
        if (filter instanceof Intersects) {
            return 7;
        }
        if (filter instanceof Overlaps) {
            return 12;
        }
        if (filter instanceof Touches) {
            return 8;
        }
        if (filter instanceof Within) {
            return 10;
        }
        if (filter instanceof PropertyIsLike) {
            return 20;
        }
        if (filter instanceof And) {
            return 2;
        }
        if (filter instanceof Not) {
            return 3;
        }
        if (filter instanceof Or) {
            return 1;
        }
        if (filter instanceof PropertyIsNull) {
            return 21;
        }
        if (filter instanceof Filter) {
            return 0;
        }
        return 0;
    }

    public static int asInt(Expression expr) {
        if (expr == null) {
            return -1;
        }
        try {
            Integer number = expr.evaluate(null, Integer.class);
            if (number == null) {
                return -1;
            }
            return number;
        }
        catch (NullPointerException npe) {
            return -1;
        }
    }

    public static String asString(Expression expr) {
        if (expr == null) {
            return null;
        }
        try {
            return expr.evaluate(null, String.class);
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public static double asDouble(Expression expr) {
        if (expr == null) {
            return Double.NaN;
        }
        try {
            Double number = expr.evaluate(null, Double.class);
            if (number == null) {
                return Double.NaN;
            }
            return number;
        }
        catch (NullPointerException npe) {
            return Double.NaN;
        }
    }

    public static <T> T asType(Expression expr, Class<T> TYPE2) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            return literal.evaluate(null, TYPE2);
        }
        if (expr instanceof Function) {
            Function function = (Function)expr;
            List<Expression> params = function.getParameters();
            if (params != null && params.size() != 0) {
                for (int i = 0; i < params.size(); ++i) {
                    Expression e = params.get(i);
                    T value = Filters.asType(e, TYPE2);
                    if (value == null) continue;
                    return value;
                }
            }
        } else {
            try {
                T value = expr.evaluate(null, TYPE2);
                if (TYPE2.isInstance(value)) {
                    return value;
                }
            }
            catch (NullPointerException expected) {
                return null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static double number(Object value) {
        if (value == null) {
            return Double.NaN;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value instanceof String) {
            String text = (String)value;
            try {
                Number number = Filters.gets(text, Number.class);
                return number.doubleValue();
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Unable to decode '" + text + "' as a number");
            }
        }
        if (value instanceof Expression) {
            throw new IllegalArgumentException("Cannot deal with un evaulated Expression");
        }
        throw new IllegalArgumentException("Unable to evaulate " + value.getClass() + " in a numeric context");
    }

    public static <T> T gets(String text, Class<T> TYPE2) throws Throwable {
        if (text == null) {
            return null;
        }
        if (TYPE2 == String.class) {
            return TYPE2.cast(text);
        }
        if (TYPE2 == Integer.class) {
            return TYPE2.cast(Integer.decode(text));
        }
        if (TYPE2 == Double.class) {
            return TYPE2.cast(Double.valueOf(text));
        }
        if (TYPE2 == Number.class) {
            try {
                return TYPE2.cast(Double.valueOf(text));
            }
            catch (NumberFormatException numberFormatException) {
                return TYPE2.cast(Integer.decode(text));
            }
        }
        if (TYPE2 == Color.class) {
            return TYPE2.cast(new Color(Integer.decode(text)));
        }
        T value = Converters.convert(text, TYPE2);
        if (value != null) {
            return TYPE2.cast(value);
        }
        try {
            Constructor<T> create = TYPE2.getConstructor(String.class);
            return create.newInstance(text);
        }
        catch (SecurityException create) {
        }
        catch (NoSuchMethodException create) {
        }
        catch (IllegalArgumentException create) {
        }
        catch (InstantiationException create) {
        }
        catch (IllegalAccessException create) {
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return null;
    }

    public static String puts(double number) {
        if (Math.rint(number) == number) {
            return Integer.toString((int)number);
        }
        return Double.toString(number);
    }

    public static String puts(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Color) {
            Color color = (Color)obj;
            return Filters.puts(color);
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return Filters.puts(number.doubleValue());
        }
        String text = Converters.convert(obj, String.class);
        if (text != null) {
            return text;
        }
        return obj.toString();
    }

    public static String puts(Color color) {
        String redCode = Integer.toHexString(color.getRed());
        String greenCode = Integer.toHexString(color.getGreen());
        String blueCode = Integer.toHexString(color.getBlue());
        if (redCode.length() == 1) {
            redCode = "0" + redCode;
        }
        if (greenCode.length() == 1) {
            greenCode = "0" + greenCode;
        }
        if (blueCode.length() == 1) {
            blueCode = "0" + blueCode;
        }
        return "#" + redCode + greenCode + blueCode;
    }

    public Filter remove(Filter baseFilter, Filter targetFilter) {
        return this.remove(baseFilter, targetFilter, true);
    }

    public static Filter removeFilter(Filter baseFilter, Filter targetFilter) {
        return STATIC.remove(baseFilter, targetFilter);
    }

    public Filter remove(Filter baseFilter, final Filter targetFilter, boolean recurse) {
        if (baseFilter == null) {
            return baseFilter;
        }
        if (targetFilter == null) {
            return baseFilter;
        }
        if (baseFilter.equals(targetFilter)) {
            return Filter.INCLUDE;
        }
        if (!(baseFilter instanceof BinaryLogicOperator)) {
            return baseFilter;
        }
        if (recurse) {
            DuplicatingFilterVisitor remove = new DuplicatingFilterVisitor(){

                @Override
                public Object visit(Or filter, Object extraData) {
                    List<Filter> newChildren = this.children(filter, targetFilter, extraData);
                    if (newChildren.isEmpty()) {
                        return Filter.EXCLUDE;
                    }
                    if (newChildren.size() == 1) {
                        return newChildren.get(0);
                    }
                    return this.getFactory(extraData).or(newChildren);
                }

                @Override
                public Object visit(And filter, Object extraData) {
                    List<Filter> newChildren = this.children(filter, targetFilter, extraData);
                    if (newChildren.isEmpty()) {
                        return Filter.INCLUDE;
                    }
                    if (newChildren.size() == 1) {
                        return newChildren.get(0);
                    }
                    return this.getFactory(extraData).and(newChildren);
                }

                private List<Filter> children(BinaryLogicOperator filter, Filter targetFilter2, Object extraData) {
                    List<Filter> children = filter.getChildren();
                    ArrayList<Filter> newChildren = new ArrayList<Filter>();
                    for (Filter child : children) {
                        if (targetFilter2.equals(child) || child == null) continue;
                        Filter newChild = (Filter)child.accept(this, extraData);
                        newChildren.add(newChild);
                    }
                    return newChildren;
                }
            };
            return (Filter)baseFilter.accept(remove, this.ff);
        }
        BinaryLogicOperator blo = (BinaryLogicOperator)baseFilter;
        List<Filter> children = blo.getChildren();
        if (children == null) {
            children = Collections.emptyList();
        }
        ArrayList<Filter> copy = new ArrayList<Filter>(children.size());
        for (Filter filter : children) {
            if (targetFilter.equals(filter)) continue;
            copy.add(filter);
        }
        if (copy.isEmpty()) {
            if (baseFilter instanceof And) {
                return Filter.INCLUDE;
            }
            if (baseFilter instanceof Or) {
                return Filter.EXCLUDE;
            }
            return Filter.EXCLUDE;
        }
        if (copy.size() == 1) {
            return (Filter)copy.get(0);
        }
        if (baseFilter instanceof And) {
            return this.ff.and(children);
        }
        if (baseFilter instanceof Or) {
            return this.ff.or(children);
        }
        return Filter.INCLUDE;
    }

    public static Filter removeFilter(Filter baseFilter, Filter targetFilter, boolean recurse) {
        return STATIC.remove(baseFilter, targetFilter, recurse);
    }

    public Set<String> attributeNames(Filter filter) {
        if (filter == null) {
            return Collections.emptySet();
        }
        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
        filter.accept(extractor, new HashSet());
        return extractor.getAttributeNameSet();
    }

    public static String[] attributeNames(Filter filter, SimpleFeatureType featureType) {
        if (filter == null) {
            return new String[0];
        }
        FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(featureType);
        filter.accept(attExtractor, null);
        String[] attributeNames = attExtractor.getAttributeNames();
        return attributeNames;
    }

    public static Set<PropertyName> propertyNames(Filter filter, SimpleFeatureType featureType) {
        if (filter == null) {
            return Collections.emptySet();
        }
        FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(featureType);
        filter.accept(attExtractor, null);
        Set<PropertyName> propertyNames = attExtractor.getPropertyNameSet();
        return propertyNames;
    }

    public static Set<PropertyName> propertyNames(Filter filter) {
        return Filters.propertyNames(filter, null);
    }

    public static Set<PropertyName> propertyNames(Expression expression, SimpleFeatureType featureType) {
        if (expression == null) {
            return Collections.emptySet();
        }
        FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(featureType);
        expression.accept(attExtractor, null);
        Set<PropertyName> propertyNames = attExtractor.getPropertyNameSet();
        return propertyNames;
    }

    public static Set<PropertyName> propertyNames(Expression expression) {
        return Filters.propertyNames(expression, null);
    }

    static boolean uses(Filter filter, String propertyName) {
        if (filter == null) {
            return false;
        }
        class SearchFilterVisitor
        extends AbstractSearchFilterVisitor {
            final /* synthetic */ String val$propertyName;

            SearchFilterVisitor(String string) {
                this.val$propertyName = string;
            }

            @Override
            protected boolean found(Object data) {
                return Boolean.TRUE == data;
            }

            @Override
            public Object visit(PropertyName name, Object data) {
                if (Utilities.equals(name.getPropertyName(), this.val$propertyName)) {
                    return true;
                }
                return data;
            }
        }
        SearchFilterVisitor search = new SearchFilterVisitor(propertyName);
        boolean found = (Boolean)filter.accept(search, false);
        return found;
    }

    public static boolean hasChildren(Filter filter) {
        return filter instanceof BinaryLogicOperator || filter instanceof Not;
    }

    public static ArrayList<Filter> children(Filter filter) {
        return Filters.children(filter, false);
    }

    public static ArrayList<Filter> children(Filter filter, boolean all) {
        final ArrayList<Filter> children = new ArrayList<Filter>();
        if (filter == null) {
            return children;
        }
        if (all) {
            filter.accept(new DefaultFilterVisitor(){

                @Override
                public Object visit(And filter, Object data) {
                    List<Filter> childList = filter.getChildren();
                    if (childList != null) {
                        for (Filter child : childList) {
                            if (child == null) continue;
                            children.add(child);
                            data = child.accept(this, data);
                        }
                    }
                    return data;
                }

                @Override
                public Object visit(Or filter, Object data) {
                    List<Filter> childList = filter.getChildren();
                    if (childList != null) {
                        for (Filter child : childList) {
                            if (child == null) continue;
                            children.add(child);
                            data = child.accept(this, data);
                        }
                    }
                    return data;
                }

                @Override
                public Object visit(Not filter, Object data) {
                    Filter child = filter.getFilter();
                    if (child != null) {
                        children.add(child);
                        data = child.accept(this, data);
                    }
                    return data;
                }
            }, null);
        } else {
            BinaryLogicOperator parent;
            List<Filter> reviewChildren;
            Not not;
            if (filter instanceof Not && (not = (Not)filter).getFilter() != null) {
                children.add(not.getFilter());
            }
            if (filter instanceof BinaryLogicOperator && (reviewChildren = (parent = (BinaryLogicOperator)filter).getChildren()) != null) {
                for (Filter child : reviewChildren) {
                    if (child == null) continue;
                    children.add(child);
                }
            }
        }
        return children;
    }

    public static <T extends Filter> T search(Filter filter, Class<T> filterType, String propertyName) {
        ArrayList<Filter> allBase = Filters.children(filter);
        for (Filter base : allBase) {
            if (!filterType.isInstance(base) || !Filters.uses(base, propertyName)) continue;
            return (T)((Filter)filterType.cast(base));
        }
        return null;
    }

    public static String findPropertyName(Filter filter) {
        if (filter == null) {
            return null;
        }
        class SearchFilterVisitor
        extends AbstractSearchFilterVisitor {
            SearchFilterVisitor() {
            }

            @Override
            protected boolean found(Object data) {
                return data != null;
            }

            @Override
            public Object visit(PropertyName name, Object data) {
                return name.getPropertyName();
            }
        }
        SearchFilterVisitor search = new SearchFilterVisitor();
        return (String)filter.accept(search, null);
    }

    static <T extends Filter> List<T> findAllByTypeAndName(Filter filter, Class<T> filterType, String property) {
        ArrayList<T> retVal = new ArrayList<T>();
        ArrayList<Filter> allBase = Filters.children(filter);
        allBase.add(0, filter);
        for (Filter base : allBase) {
            if (!filterType.isInstance(base) || !Filters.uses(base, property)) continue;
            retVal.add(filterType.cast(base));
        }
        return retVal;
    }
}

