/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.io.File;

public class OSGiDefaultClassLoaderHandler
implements ClassLoaderHandler {
    public static final String[] HANDLED_CLASSLOADERS = new String[]{"org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader"};

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ClassLoader classloader, ClasspathFinder classpathFinder, ScanSpec scanSpec, LogNode log) {
        Object classpathManager = ReflectionUtils.invokeMethod(classloader, "getClasspathManager", false);
        Object[] entries = (Object[])ReflectionUtils.getFieldVal(classpathManager, "entries", false);
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                Object bundleFile = ReflectionUtils.invokeMethod(entries[i], "getBundleFile", false);
                File baseFile = (File)ReflectionUtils.invokeMethod(bundleFile, "getBaseFile", false);
                if (baseFile == null) continue;
                classpathFinder.addClasspathElement(baseFile.getPath(), classloader, log);
            }
        }
    }
}

