/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6.impl;

import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.xml.v0_6.impl.EntityWriter;
import org.openstreetmap.osmosis.xml.v0_6.impl.TagWriter;
import org.openstreetmap.osmosis.xml.v0_6.impl.WayNodeWriter;

public class WayWriter
extends EntityWriter {
    private WayNodeWriter wayNodeWriter;
    private TagWriter tagWriter;

    public WayWriter(String elementName, int indentLevel) {
        super(elementName, indentLevel);
        this.tagWriter = new TagWriter("tag", indentLevel + 1);
        this.wayNodeWriter = new WayNodeWriter("nd", indentLevel + 1);
    }

    public void process(Way way) {
        this.beginOpenElement();
        this.addCommonAttributes(way);
        this.addMetatags(way);
        List<WayNode> wayNodes = way.getWayNodes();
        Collection<Tag> tags = way.getTags();
        if (wayNodes.size() > 0 || tags.size() > 0) {
            this.endOpenElement(false);
            for (WayNode wayNode : wayNodes) {
                this.wayNodeWriter.processWayNode(wayNode);
            }
            for (Tag tag : tags) {
                this.tagWriter.process(tag);
            }
            this.closeElement();
        } else {
            this.endOpenElement(true);
        }
    }

    @Override
    public void setWriter(Writer writer) {
        super.setWriter(writer);
        this.wayNodeWriter.setWriter(writer);
        this.tagWriter.setWriter(writer);
    }
}

