/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.xml.v0_6.impl.OsmChangeWriter;

public class XmlChangeUploader
implements ChangeSink {
    private static final Logger LOG = Logger.getLogger(XmlChangeUploader.class.getName());
    private static final String DEFAULTAPIBASEURL = "http://api.openstreetmap.org/api/0.6";
    private String myBaseURL;
    private String myUserName;
    private String myPassword;
    private String myComment;
    private OsmChangeWriter myChangeWriter;
    private int myChangesetNumber = -1;
    private StringWriter myChangesetBuffer = new StringWriter();

    public XmlChangeUploader(String aBaseURL, String aUserName, String aPassword, String aComment) {
        this.myBaseURL = aBaseURL == null ? DEFAULTAPIBASEURL : aBaseURL;
        if (aUserName == null) {
            throw new IllegalArgumentException("null username given");
        }
        this.myUserName = aUserName;
        if (aPassword == null) {
            throw new IllegalArgumentException("null password given");
        }
        this.myPassword = aPassword;
        this.myComment = aComment == null ? "" : aComment;
        this.myPassword = aPassword;
        this.myChangeWriter = new OsmChangeWriter("osmChange", 0);
    }

    protected final void initialize() throws IOException {
        if (this.myChangesetNumber == -1) {
            URL url = new URL(this.myBaseURL + "/changeset/create");
            System.err.println("DEBUG: URL= " + url.toString());
            HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
            httpCon.setRequestProperty("User-Agent", "Osmosis/0.44.1");
            httpCon.setRequestProperty("Authorization", "Basic " + Base64.encodeBase64String((this.myUserName + ":" + this.myPassword).getBytes("UTF8")));
            httpCon.setDoOutput(true);
            httpCon.setRequestMethod("PUT");
            OutputStreamWriter out = new OutputStreamWriter(httpCon.getOutputStream());
            out.write("<osm version=\"0.6\" generator=\"Osmosis 0.44.1\">\n\t<changeset>\n");
            out.write("\t\t<tag k=\"created_by\" v=\"Osmosis\"/>\n");
            out.write("\t\t<tag k=\"comment\" v=\"" + this.myComment + "\"/>\n");
            out.write("\t</changeset>\n</osm>");
            out.close();
            int responseCode = httpCon.getResponseCode();
            if (responseCode != 200) {
                InputStreamReader reader = new InputStreamReader(httpCon.getInputStream());
                LOG.severe(this.readAll(reader).toString());
                throw new IllegalStateException("Http-Status-code is not 200 OK but " + responseCode + " \"" + httpCon.getResponseMessage() + "\" Error=" + httpCon.getHeaderField("Error"));
            }
            InputStreamReader in = new InputStreamReader(httpCon.getInputStream());
            char[] buffer = new char[127];
            int len = in.read(buffer);
            int changeset = Integer.parseInt(new String(buffer, 0, len));
            LOG.info("opened changeset with ID: " + changeset);
            this.myChangesetNumber = changeset;
            this.myChangeWriter.setWriter(this.myChangesetBuffer);
            this.myChangeWriter.begin();
        }
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
    }

    @Override
    public final void process(ChangeContainer changeContainer) {
        try {
            this.initialize();
            this.myChangeWriter.process(changeContainer);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Cannot open changeset on server", e);
        }
    }

    @Override
    public final void complete() {
        try {
            this.myChangeWriter.end();
            LOG.fine("complete() called");
            this.uploadChangeBuffer();
            this.closeChangeset();
        }
        catch (Exception e) {
            throw new OsmosisRuntimeException("cannot upload or close changeset.", e);
        }
    }

    private void uploadChangeBuffer() throws IOException {
        URL url = new URL(this.myBaseURL + "/changeset/" + this.myChangesetNumber + "/upload");
        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
        httpCon.setDoOutput(true);
        httpCon.setRequestProperty("Authorization", "Basic " + Base64.encodeBase64String((this.myUserName + ":" + this.myPassword).getBytes("UTF8")));
        OutputStream out = httpCon.getOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF8");
        writer.flush();
        String changeSet = this.myChangesetBuffer.getBuffer().toString();
        System.out.println("changeset we got uploading:\n" + changeSet);
        String modified = changeSet.replaceAll("changeset=\"[0-9]*\"", "changeset=\"" + this.myChangesetNumber + "\"");
        System.out.println("changeset we are uploading:\n" + modified);
        writer.write(modified);
        writer.close();
        int responseCode = httpCon.getResponseCode();
        LOG.fine("response-code to changeset: " + responseCode);
        if (responseCode != 200) {
            throw new IllegalStateException("Http-Status-code is not 200 OK but " + responseCode + " \"" + httpCon.getResponseMessage() + "\" Error=" + httpCon.getHeaderField("Error"));
        }
    }

    private void closeChangeset() throws IOException {
        URL url = new URL(this.myBaseURL + "/changeset/" + this.myChangesetNumber + "/close");
        System.err.println("DEBUG: URL= " + url.toString());
        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
        httpCon.setDoOutput(true);
        httpCon.setRequestMethod("PUT");
        httpCon.setRequestProperty("Authorization", "Basic " + Base64.encodeBase64String((this.myUserName + ":" + this.myPassword).getBytes("UTF8")));
        httpCon.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpCon.connect();
        int responseCode = httpCon.getResponseCode();
        LOG.info("response-code to closing of changeset: " + responseCode);
        this.myChangesetNumber = -1;
        if (responseCode != 200) {
            throw new IllegalStateException("Http-Status-code is not 200 OK but " + responseCode + " \"" + httpCon.getResponseMessage() + "\" Error=" + httpCon.getHeaderField("Error"));
        }
    }

    private StringBuilder readAll(Reader aReader) throws IOException {
        char[] buffer = new char[127];
        int reat = -1;
        StringBuilder sb = new StringBuilder();
        while ((reat = aReader.read(buffer)) >= 0) {
            sb.append(buffer, 0, reat);
        }
        aReader.close();
        return sb;
    }

    @Override
    public final void release() {
        if (this.myChangesetNumber != -1) {
            try {
                LOG.fine("release() called");
                this.closeChangeset();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Cannot close changeset.", e);
            }
        }
    }
}

