/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.xml.v0_6;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.xml.common.CompressionActivator;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.impl.FastXmlParser;

public class FastXmlReader
implements RunnableSource {
    private static Logger log = Logger.getLogger(FastXmlReader.class.getName());
    private Sink sink;
    private final File file;
    private final boolean enableDateParsing;
    private final CompressionMethod compressionMethod;

    public FastXmlReader(File file, boolean enableDateParsing, CompressionMethod compressionMethod) {
        this.file = file;
        this.enableDateParsing = enableDateParsing;
        this.compressionMethod = compressionMethod;
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }

    @Override
    public void run() {
        InputStream inputStream = null;
        FastXmlParser parser = null;
        try {
            this.sink.initialize(Collections.<String, Object>emptyMap());
            inputStream = this.file.getName().equals("-") ? System.in : new FileInputStream(this.file);
            inputStream = new CompressionActivator(this.compressionMethod).createCompressionInputStream(inputStream);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", false);
            factory.setProperty("javax.xml.stream.isNamespaceAware", false);
            factory.setProperty("javax.xml.stream.isValidating", false);
            XMLStreamReader xpp = factory.createXMLStreamReader(inputStream);
            parser = new FastXmlParser(this.sink, xpp, this.enableDateParsing);
            parser.readOsm();
            this.sink.complete();
        }
        catch (Exception e) {
            throw new OsmosisRuntimeException("Unable to read XML file " + this.file + ".", e);
        }
        finally {
            this.sink.release();
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Unable to close input stream.", e);
                }
                inputStream = null;
            }
        }
    }
}

