/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.pipeline.common;

import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.pipeline.common.PipeTasks;
import org.openstreetmap.osmosis.core.task.common.Task;

public abstract class TaskManager {
    private String taskId;
    private Map<Integer, String> inputPipeNames;
    private Map<Integer, String> outputPipeNames;

    protected TaskManager(String taskId, Map<String, String> pipeArgs) {
        this.taskId = taskId;
        this.inputPipeNames = this.buildPipes(pipeArgs, true);
        this.outputPipeNames = this.buildPipes(pipeArgs, false);
    }

    private int getPipeIndex(String pipeArgNameSuffix) {
        int pipeIndex;
        if (pipeArgNameSuffix.length() <= 0) {
            pipeIndex = 0;
        } else {
            if (pipeArgNameSuffix.indexOf(46) != 0) {
                throw new OsmosisRuntimeException("Task " + this.taskId + " contains a pipe definition without '.' between prefix and suffix.");
            }
            String indexString = pipeArgNameSuffix.substring(1);
            if (indexString.length() <= 0) {
                throw new OsmosisRuntimeException("Task " + this.taskId + " contains a pipe definition without an index after the '.'.");
            }
            try {
                pipeIndex = Integer.parseInt(indexString);
            }
            catch (NumberFormatException e) {
                throw new OsmosisRuntimeException("Task " + this.taskId + " has a pipe with an incorrect index suffix.");
            }
        }
        return pipeIndex;
    }

    private Map<Integer, String> buildPipes(Map<String, String> pipeArgs, boolean buildInputPipes) {
        String pipeType;
        String pipeArgumentPrefix;
        HashMap<Integer, String> pipes = new HashMap<Integer, String>();
        if (buildInputPipes) {
            pipeArgumentPrefix = "inPipe";
            pipeType = "input";
        } else {
            pipeArgumentPrefix = "outPipe";
            pipeType = "output";
        }
        for (String pipeArgName : pipeArgs.keySet()) {
            if (pipeArgName.indexOf(pipeArgumentPrefix) != 0) continue;
            Integer pipeIndex = new Integer(this.getPipeIndex(pipeArgName.substring(pipeArgumentPrefix.length())));
            if (pipes.containsKey(pipeIndex)) {
                throw new OsmosisRuntimeException("Task " + this.taskId + " has a duplicate " + pipeType + " pipe with index " + pipeIndex + ".");
            }
            pipes.put(pipeIndex, pipeArgs.get(pipeArgName));
        }
        return pipes;
    }

    protected Task getInputTask(PipeTasks pipeTasks, int pipeIndex, Class<? extends Task> requiredTaskType) {
        Integer pipeIndexO = new Integer(pipeIndex);
        Task inputTask = this.inputPipeNames.containsKey(pipeIndexO) ? pipeTasks.retrieveTask(this.taskId, this.inputPipeNames.get(pipeIndexO), requiredTaskType) : pipeTasks.retrieveTask(this.taskId, requiredTaskType);
        return inputTask;
    }

    protected void setOutputTask(PipeTasks pipeTasks, Task outputTask, int pipeIndex) {
        Integer pipeIndexO = new Integer(pipeIndex);
        if (this.outputPipeNames.containsKey(pipeIndexO)) {
            pipeTasks.putTask(this.taskId, this.outputPipeNames.get(pipeIndexO), outputTask);
        } else {
            pipeTasks.putTask(this.taskId, outputTask);
        }
    }

    protected String getTaskId() {
        return this.taskId;
    }

    public abstract void connect(PipeTasks var1);

    public abstract void execute();

    public abstract boolean waitForCompletion();
}

