/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.statistic;

import java.text.NumberFormat;
import java.util.function.Consumer;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.statistic.Statistic;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;

public abstract class AbstractStatistic
implements Statistic {
    private static final long DEFAULT_LOG_PRINT_FREQUENCY = 1000000L;
    private static final String DEFAULT_NAME = "";
    private final NumberFormat numberFormat;
    private Time startTime;
    private long logPrintFrequency;
    private String name;
    private long count;
    private Consumer<String> log = arg_0 -> ((Logger)logger).info(arg_0);

    protected AbstractStatistic(Logger logger) {
        this(logger, 1000000L, DEFAULT_NAME);
    }

    protected AbstractStatistic(Logger logger, long logPrintFrequency) {
        this(logger, logPrintFrequency, DEFAULT_NAME);
    }

    protected AbstractStatistic(Logger logger, long logPrintFrequency, String name) {
        this.logPrintFrequency = logPrintFrequency;
        this.name = name;
        this.startTime = Time.now();
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(true);
    }

    protected AbstractStatistic(Logger logger, String name) {
        this(logger, 1000000L, name);
    }

    public void clear() {
        this.count = 0L;
        this.startTime = Time.now();
    }

    public void clearCounter() {
        this.count = 0L;
    }

    public long count() {
        return this.count;
    }

    public Consumer<String> getLog() {
        return this.log;
    }

    public long getLogPrintFrequency() {
        return this.logPrintFrequency;
    }

    public String getName() {
        return this.name;
    }

    public Time getStartTime() {
        return this.startTime;
    }

    public void increment() {
        ++this.count;
        if (this.count % this.logPrintFrequency == 0L) {
            this.log.accept(this.toString());
        }
        this.onIncrement();
    }

    @Override
    public void increment(double value) {
        this.increment();
        this.onIncrement(value);
    }

    public void logUsingLevel(Consumer<String> log) {
        this.log = log;
    }

    public void setLogPrintFrequency(long logPrintFrequency) {
        this.logPrintFrequency = logPrintFrequency;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Duration sinceStart() {
        return this.startTime.untilNow();
    }

    public String toString() {
        return this.name + " Count: " + this.numberFormat.format(this.count) + ", Time spent: " + this.sinceStart();
    }

    public String toStringWithoutTimer() {
        return this.name + " Count: " + this.numberFormat.format(this.count);
    }

    protected NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    protected abstract void onIncrement();

    protected abstract void onIncrement(double var1);

    protected void setCount(long count) {
        this.count = count;
    }
}

