/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.runtime;

import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.threads.Pool;
import org.openstreetmap.atlas.utilities.threads.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RunScriptMonitor {
    private static final Duration REFRESH_DURATION = Duration.milliseconds(100L);
    private static final Logger logger = LoggerFactory.getLogger(RunScriptMonitor.class);
    private Thread out;
    private Thread err;

    protected void parse(InputStream standardOut, InputStream standardErr) {
        this.out = new Thread(() -> this.parseStandardOutput(new InputStreamResource(standardOut).lines()));
        this.err = new Thread(() -> this.parseStandardError(new InputStreamResource(standardErr).lines()));
        this.out.setPriority(10);
        this.err.setPriority(10);
        this.out.start();
        this.err.start();
    }

    protected abstract void parseStandardError(Iterable<String> var1);

    protected abstract void parseStandardOutput(Iterable<String> var1);

    protected void waitForCompletion(Duration maximum) {
        try (Pool waiter = new Pool(1, "waiter", Duration.ONE_SECOND);){
            Result<Boolean> result = waiter.queue(() -> {
                while (this.out.isAlive() || this.err.isAlive()) {
                    REFRESH_DURATION.sleep();
                }
                return true;
            });
            result.get(maximum);
        }
        catch (TimeoutException e) {
            logger.warn("RunScript logs monitor did not finish in {}.", (Object)maximum);
        }
    }

    public static class PrinterMonitor
    extends RunScriptMonitor {
        private final Logger logger;

        public PrinterMonitor(Logger logger) {
            this.logger = logger;
        }

        @Override
        protected void parseStandardError(Iterable<String> lines) {
            this.parseStream(lines);
        }

        @Override
        protected void parseStandardOutput(Iterable<String> lines) {
            this.parseStream(lines);
        }

        private void parseStream(Iterable<String> lines) {
            lines.forEach(line -> this.logger.info(line));
        }
    }
}

