/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.direction;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Segment;
import org.openstreetmap.atlas.geography.atlas.builder.store.AtlasPrimitiveEdge;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.utilities.scalars.Angle;

public final class EdgeDirectionComparator {
    public static final Angle DEFAULT_OPPOSITE_DIRECTION_LOWER_LIMIT = Angle.degrees(171.0);
    public static final Angle DEFAULT_OPPOSITE_DIRECTION_UPPER_LIMIT = Angle.degrees(-171.0);
    public static final Angle DEFAULT_SAME_DIRECTION_LOWER_LIMIT = Angle.degrees(-9.0);
    public static final Angle DEFAULT_SAME_DIRECTION_UPPER_LIMIT = Angle.degrees(9.0);
    private final Angle oppositeDirectionLowerLimit;
    private final Angle oppositeDirectionUpperLimit;
    private final Angle sameDirectionLowerLimit;
    private final Angle sameDirectionUpperLimit;

    public EdgeDirectionComparator() {
        this(DEFAULT_OPPOSITE_DIRECTION_LOWER_LIMIT, DEFAULT_OPPOSITE_DIRECTION_UPPER_LIMIT, DEFAULT_SAME_DIRECTION_LOWER_LIMIT, DEFAULT_SAME_DIRECTION_UPPER_LIMIT);
    }

    public EdgeDirectionComparator(Angle oppositeDirectionLowerLimit, Angle oppositeDirectionUpperLimit, Angle sameDirectionLowerLimit, Angle sameDirectionUpperLimit) {
        this.oppositeDirectionLowerLimit = oppositeDirectionLowerLimit;
        this.oppositeDirectionUpperLimit = oppositeDirectionUpperLimit;
        this.sameDirectionLowerLimit = sameDirectionLowerLimit;
        this.sameDirectionUpperLimit = sameDirectionUpperLimit;
    }

    public boolean isOppositeDirection(AtlasPrimitiveEdge incomingEdge, AtlasPrimitiveEdge outgoingEdge, boolean useOverallHeading) {
        if (incomingEdge.isReversedEdge(outgoingEdge)) {
            return true;
        }
        return this.isOppositeDirection(incomingEdge.getPolyLine(), outgoingEdge.getPolyLine(), useOverallHeading);
    }

    public boolean isOppositeDirection(Edge incomingEdge, Edge outgoingEdge, boolean useOverallHeading) {
        if (incomingEdge.isReversedEdge(outgoingEdge)) {
            return true;
        }
        return this.isOppositeDirection(incomingEdge.asPolyLine(), outgoingEdge.asPolyLine(), useOverallHeading);
    }

    public boolean isOppositeDirection(Heading incomingEdgeHeading, Heading outgoingEdgeHeading) {
        Angle headingDifference = incomingEdgeHeading.subtract(outgoingEdgeHeading);
        return headingDifference.isGreaterThanOrEqualTo(this.oppositeDirectionLowerLimit) || headingDifference.isLessThan(this.oppositeDirectionUpperLimit);
    }

    public boolean isOppositeDirection(PolyLine incomingEdgePolyline, PolyLine outgoingEdgePolyline, boolean useOverallHeading) {
        return useOverallHeading ? this.isOppositeDirectionUsingOverallHeading(incomingEdgePolyline, outgoingEdgePolyline) : this.isOppositeDirectionUsingSegmentHeading(incomingEdgePolyline, outgoingEdgePolyline);
    }

    public boolean isOppositeDirectionUsingOverallHeading(PolyLine incomingEdgePolyline, PolyLine outgoingEdgePolyline) {
        boolean oppositeDirection = false;
        if (Math.min(incomingEdgePolyline.size(), outgoingEdgePolyline.size()) > 1) {
            Optional<Heading> incomingSegmentHeading = incomingEdgePolyline.overallHeading();
            Optional<Heading> outgoingSegmentHeading = outgoingEdgePolyline.overallHeading();
            if (incomingSegmentHeading.isPresent() && outgoingSegmentHeading.isPresent()) {
                oppositeDirection = this.isOppositeDirection(incomingSegmentHeading.get(), outgoingSegmentHeading.get());
            }
        }
        return oppositeDirection;
    }

    public boolean isOppositeDirectionUsingSegmentHeading(PolyLine incomingEdgePolyline, PolyLine outgoingEdgePolyline) {
        boolean oppositeDirection = false;
        if (Math.min(incomingEdgePolyline.size(), outgoingEdgePolyline.size()) > 1) {
            List<Segment> incomingSegments = incomingEdgePolyline.segments();
            Optional<Heading> incomingSegmentHeading = incomingSegments.get(incomingSegments.size() - 1).heading();
            Optional<Heading> outgoingSegmentHeading = outgoingEdgePolyline.segments().get(0).heading();
            if (incomingSegmentHeading.isPresent() && outgoingSegmentHeading.isPresent()) {
                oppositeDirection = this.isOppositeDirection(incomingSegmentHeading.get(), outgoingSegmentHeading.get());
            }
        }
        return oppositeDirection;
    }

    public boolean isParallel(Edge edgeA, Collection<Edge> edges, boolean useOverallHeading) {
        return edges.stream().anyMatch(edge -> this.isParallel(edgeA, (Edge)edge, useOverallHeading));
    }

    public boolean isParallel(Edge edgeA, Edge edgeB, boolean useOverallHeading) {
        return this.isSameDirection(edgeA, edgeB, useOverallHeading) || this.isOppositeDirection(edgeA, edgeB, useOverallHeading);
    }

    public boolean isSameDirection(AtlasPrimitiveEdge edgeA, AtlasPrimitiveEdge edgeB, boolean useOverallHeading) {
        if (!edgeA.isReversedEdge(edgeB)) {
            return this.isSameDirection(edgeA.getPolyLine(), edgeB.getPolyLine(), useOverallHeading);
        }
        return false;
    }

    public boolean isSameDirection(Edge edgeA, Edge edgeB, boolean useOverallHeading) {
        if (!edgeA.isReversedEdge(edgeB)) {
            return this.isSameDirection(edgeA.asPolyLine(), edgeB.asPolyLine(), useOverallHeading);
        }
        return false;
    }

    public boolean isSameDirection(Heading headingA, Heading headingB) {
        Angle headingDifference = headingB.subtract(headingA);
        boolean sameDirection = headingDifference.isGreaterThanOrEqualTo(this.sameDirectionLowerLimit) && headingDifference.isLessThan(this.sameDirectionUpperLimit);
        return sameDirection;
    }

    public boolean isSameDirection(PolyLine polyLineA, PolyLine polyLineB, boolean useOverallHeading) {
        return useOverallHeading ? this.isSameDirectionUsingOverallHeading(polyLineA, polyLineB) : this.isSameDirectionUsingSegmentHeading(polyLineA, polyLineB);
    }

    public boolean isSameDirectionUsingOverallHeading(PolyLine polyLineA, PolyLine polyLineB) {
        boolean sameDirection = false;
        if (!polyLineA.isPoint() && !polyLineB.isPoint()) {
            Optional<Heading> headingA = polyLineA.overallHeading();
            Optional<Heading> headingB = polyLineB.overallHeading();
            if (headingA.isPresent() && headingB.isPresent()) {
                sameDirection = this.isSameDirection(headingA.get(), headingB.get());
            }
        }
        return sameDirection;
    }

    public boolean isSameDirectionUsingSegmentHeading(PolyLine incomingEdgePolyline, PolyLine outgoingEdgePolyline) {
        boolean sameDirection = false;
        if (!incomingEdgePolyline.isPoint() && !outgoingEdgePolyline.isPoint()) {
            Optional<Heading> incomingSegmentHeading = incomingEdgePolyline.segments().get(incomingEdgePolyline.segments().size() - 1).heading();
            Optional<Heading> outgoingSegmentHeading = outgoingEdgePolyline.segments().get(0).heading();
            if (incomingSegmentHeading.isPresent() && outgoingSegmentHeading.isPresent()) {
                sameDirection = this.isSameDirection(incomingSegmentHeading.get(), outgoingSegmentHeading.get());
            }
        }
        return sameDirection;
    }
}

