/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.compression;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.proto.adapters.ProtoIntegerStringDictionaryAdapter;

public class IntegerDictionary<Type>
implements Serializable,
ProtoSerializable {
    private static final long serialVersionUID = -1781411097803512149L;
    public static final String FIELD_WORD_TO_INDEX = "wordToIndex";
    public static final String FIELD_INDEX_TO_WORD = "indexToWord";
    public static final String FIELD_INDEX = "index";
    private final Map<Type, Integer> wordToIndex = new HashMap<Type, Integer>();
    private final Map<Integer, Type> indexToWord = new HashMap<Integer, Type>();
    private int index = 0;

    public synchronized int add(Type word) {
        if (this.wordToIndex.containsKey(word)) {
            return this.wordToIndex.get(word);
        }
        this.wordToIndex.put(word, this.index);
        this.indexToWord.put(this.index, word);
        return this.index++;
    }

    public boolean equals(Object other) {
        if (other instanceof IntegerDictionary) {
            if (this == other) {
                return true;
            }
            IntegerDictionary that = (IntegerDictionary)other;
            if (this.size() != that.size()) {
                return false;
            }
            if (!this.wordToIndex.equals(that.wordToIndex)) {
                return false;
            }
            return this.indexToWord.equals(that.indexToWord);
        }
        return false;
    }

    @Override
    public ProtoAdapter getProtoAdapter() {
        return new ProtoIntegerStringDictionaryAdapter();
    }

    public int hashCode() {
        int valueHash;
        int keyHash;
        Integer value;
        int initialPrime = 31;
        int hashSeed = 37;
        int hash = 1147 + Integer.valueOf(this.size()).hashCode();
        for (Type Type2 : this.wordToIndex.keySet()) {
            value = this.wordToIndex.get(Type2);
            keyHash = Type2 == null ? 0 : Type2.hashCode();
            valueHash = value == null ? 0 : value.hashCode();
            hash = 37 * hash + keyHash;
            hash = 37 * hash + valueHash;
        }
        for (Integer n : this.indexToWord.keySet()) {
            value = this.indexToWord.get(n);
            keyHash = n == null ? 0 : n.hashCode();
            valueHash = value == null ? 0 : ((Object)value).hashCode();
            hash = 37 * hash + keyHash;
            hash = 37 * hash + valueHash;
        }
        return hash;
    }

    public int size() {
        return this.index;
    }

    public Type word(int index) {
        return this.indexToWord.get(index);
    }
}

