/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.cli.operations;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.atlas.utilities.cli.operations.AbstractOperation;
import org.openstreetmap.atlas.utilities.cli.operations.base.SSHOperationResults;

public class LSOperation
extends AbstractOperation {
    @Override
    public LSOperation asUser(String username) {
        super.asUser(username);
        return this;
    }

    public List<String> list(Path remotePath) throws InterruptedException, IOException {
        if (remotePath == null) {
            throw new IllegalArgumentException("remotePath can't be null");
        }
        this.ssh().addArgs("ls", "-1", remotePath.toString());
        SSHOperationResults results = this.handleResults(this.ssh().execute());
        return Arrays.asList(results.getOutput().split("\n"));
    }

    @Override
    public LSOperation onHost(String host) {
        super.onHost(host);
        return this;
    }

    @Override
    public LSOperation onPort(int portNumber) {
        super.onPort(portNumber);
        return this;
    }
}

