/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.cli.operations;

import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.openstreetmap.atlas.utilities.cli.operations.AbstractHDFSOperation;
import org.openstreetmap.atlas.utilities.cli.operations.base.SSHOperation;
import org.openstreetmap.atlas.utilities.cli.operations.base.SSHOperationResults;

public class HDFSMkdirOperation
extends AbstractHDFSOperation {
    @Override
    public HDFSMkdirOperation asUser(String username) {
        super.asUser(username);
        return this;
    }

    public boolean mkdir(Path ... remotePaths) throws InterruptedException, IOException {
        if (remotePaths.length == 0) {
            throw new IllegalArgumentException("Need at least one remote path");
        }
        SSHOperation operation = this.prepareSSH().addArgs("-mkdir", "-p");
        Stream.of(remotePaths).map(Path::toString).map(this::preparePath).forEach(xva$0 -> operation.addArgs((String)xva$0));
        SSHOperationResults results = this.handleResults(this.ssh().execute());
        return results.getReturnValue() == 0;
    }

    @Override
    public HDFSMkdirOperation onHost(String host) {
        super.onHost(host);
        return this;
    }

    @Override
    public HDFSMkdirOperation onPort(int portNumber) {
        super.onPort(portNumber);
        return this;
    }

    @Override
    public HDFSMkdirOperation withConfiguration(String configuration) {
        super.withConfiguration(configuration);
        return this;
    }
}

