/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.cli.operations;

import java.util.Optional;
import org.openstreetmap.atlas.utilities.cli.operations.AbstractOperation;
import org.openstreetmap.atlas.utilities.cli.operations.base.SSHOperation;

public abstract class AbstractHDFSOperation
extends AbstractOperation {
    private Optional<String> customConfiguration = Optional.empty();
    private Optional<String> customHostname = Optional.empty();

    protected AbstractHDFSOperation() {
    }

    public AbstractHDFSOperation withConfiguration(String configuration) {
        this.customConfiguration = Optional.ofNullable(configuration);
        return this;
    }

    public AbstractHDFSOperation withCustomHostname(String customHostname) {
        this.customHostname = Optional.ofNullable(customHostname);
        return this;
    }

    protected String preparePath(String input) {
        if (input == null || input.startsWith("hdfs://")) {
            return input;
        }
        if (this.customHostname.isPresent()) {
            return String.format("hdfs://%s%s", this.customHostname.get(), input);
        }
        return input;
    }

    protected SSHOperation prepareSSH() {
        SSHOperation returnValue = this.ssh();
        returnValue.addArgs("hdfs");
        this.customConfiguration.ifPresent(configuration -> returnValue.addArgs("--config", (String)configuration));
        returnValue.addArgs("dfs");
        return returnValue;
    }
}

