/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.caching.strategies;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.openstreetmap.atlas.streaming.resource.ByteArrayResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.caching.strategies.AbstractCachingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayCachingStrategy
extends AbstractCachingStrategy {
    private static final long DEFAULT_BYTE_ARRAY_SIZE = 0x200000L;
    private static final Logger logger = LoggerFactory.getLogger(ByteArrayCachingStrategy.class);
    private final Map<UUID, ByteArrayResource> resourceCache = new HashMap<UUID, ByteArrayResource>();
    private long initialArraySize = 0x200000L;
    private boolean useExactResourceSize = false;

    @Override
    public Optional<Resource> attemptFetch(URI resourceURI, Function<URI, Resource> defaultFetcher) {
        UUID resourceUUID = this.getUUIDForResourceURI(resourceURI);
        if (!this.resourceCache.containsKey(resourceUUID)) {
            ByteArrayResource resourceBytes;
            logger.info("Attempting to cache resource {} in byte array keyed on UUID {}", (Object)resourceURI, (Object)resourceUUID.toString());
            Resource resource = defaultFetcher.apply(resourceURI);
            if (this.useExactResourceSize) {
                long resourceLength = resource.length();
                logger.info("Using extact resource length {}", (Object)resourceLength);
                resourceBytes = new ByteArrayResource(resourceLength);
            } else {
                logger.info("Using initial array size {}", (Object)this.initialArraySize);
                resourceBytes = new ByteArrayResource(this.initialArraySize);
            }
            resourceBytes.writeAndClose(resource.readBytesAndClose());
            this.resourceCache.put(resourceUUID, resourceBytes);
        }
        logger.info("Returning cached resource {} from byte array keyed on UUID {}", (Object)resourceURI, (Object)resourceUUID.toString());
        return Optional.of(this.resourceCache.get(resourceUUID));
    }

    @Override
    public String getName() {
        return "ByteArrayCachingStrategy";
    }

    @Override
    public void invalidate() {
        this.resourceCache.clear();
    }

    public ByteArrayCachingStrategy useExactResourceSize() {
        this.useExactResourceSize = true;
        return this;
    }

    public ByteArrayCachingStrategy withInitialArraySize(long initialSize) {
        this.initialArraySize = initialSize;
        return this;
    }
}

