/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import java.io.Serializable;
import java.util.stream.IntStream;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.collections.StringList;

public abstract class PrimitiveArray<T>
implements Serializable {
    private static final long serialVersionUID = 7815464773512459667L;
    private final int size;

    public PrimitiveArray(int size) {
        this.size = size;
    }

    public abstract T get(int var1);

    public abstract PrimitiveArray<T> getNewArray(int var1);

    public abstract void set(int var1, T var2);

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        StringList list = new StringList();
        for (int i = 0; i < this.size(); ++i) {
            list.add(this.get(i).toString());
        }
        builder.append(list.join(", "));
        builder.append("]");
        return builder.toString();
    }

    public PrimitiveArray<T> trimmed(int size) {
        if (size >= this.size) {
            return this;
        }
        PrimitiveArray<T> result = this.getNewArray(size);
        IntStream.range(0, size).forEach(i -> result.set(i, this.get(i)));
        return result;
    }

    public PrimitiveArray<T> withNewSize(int newSize) {
        if (newSize < this.size()) {
            throw new CoreException("Cannot copy into a smaller array. This is " + this.size() + " and the new size asked is " + newSize);
        }
        PrimitiveArray<T> young = this.getNewArray(newSize);
        for (int i = 0; i < this.size(); ++i) {
            young.set(i, this.get(i));
        }
        return young;
    }
}

