/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.StringCompressedPolyLine;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.proto.adapters.ProtoPolyLineArrayAdapter;
import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.PrimitiveArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolyLineArray
extends LargeArray<PolyLine>
implements ProtoSerializable {
    private static final Logger logger = LoggerFactory.getLogger(PolyLineArray.class);
    private static final long serialVersionUID = -4475168018638543482L;

    public PolyLineArray(long maximumSize) {
        super(maximumSize);
    }

    public PolyLineArray(long maximumSize, int memoryBlockSize, int subArraySize) {
        super(maximumSize, memoryBlockSize, subArraySize);
    }

    private PolyLineArray() {
    }

    @Override
    public ProtoAdapter getProtoAdapter() {
        return new ProtoPolyLineArrayAdapter();
    }

    @Override
    protected PrimitiveArray<PolyLine> getNewArray(int size) {
        return new PrimitivePolyLineArray(size);
    }

    public static class PrimitivePolyLineArray
    extends PrimitivePointsArray<PolyLine> {
        private static final long serialVersionUID = -9008848366079793820L;

        public PrimitivePolyLineArray(int size) {
            super(size);
        }

        @Override
        public PolyLine get(int index) {
            return new StringCompressedPolyLine(this.getEncodings()[index]).asPolyLine();
        }

        @Override
        public PrimitiveArray<PolyLine> getNewArray(int size) {
            return new PrimitivePolyLineArray(size);
        }
    }

    public static abstract class PrimitivePointsArray<Poly extends PolyLine>
    extends PrimitiveArray<Poly> {
        private static final long serialVersionUID = 3532399057462343784L;
        private final byte[][] encodings;

        public PrimitivePointsArray(int size) {
            super(size);
            this.encodings = new byte[size][];
        }

        @Override
        public void set(int index, Poly item) {
            StringCompressedPolyLine compressed;
            try {
                compressed = new StringCompressedPolyLine((PolyLine)item);
            }
            catch (StringCompressedPolyLine.PolyLineCompressionException e) {
                logger.error("Unable to compress polyLine {} at index {}. Sending to Null Island.", new Object[]{item, index, e});
                compressed = new StringCompressedPolyLine(new PolyLine((Iterable<? extends Location>)Location.CENTER));
            }
            this.encodings[index] = compressed.getEncoding();
        }

        protected byte[][] getEncodings() {
            return this.encodings;
        }
    }
}

