/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.arrays;

import java.util.Objects;
import org.openstreetmap.atlas.proto.ProtoSerializable;
import org.openstreetmap.atlas.proto.adapters.ProtoAdapter;
import org.openstreetmap.atlas.proto.adapters.ProtoIntegerArrayOfArraysAdapter;
import org.openstreetmap.atlas.utilities.arrays.LargeArray;
import org.openstreetmap.atlas.utilities.arrays.PrimitiveArray;

public class IntegerArrayOfArrays
extends LargeArray<int[]>
implements ProtoSerializable {
    private static final long serialVersionUID = 6793499910834785994L;

    public IntegerArrayOfArrays(long maximumSize) {
        super(maximumSize);
    }

    public IntegerArrayOfArrays(long maximumSize, int memoryBlockSize, int subArraySize) {
        super(maximumSize, memoryBlockSize, subArraySize);
    }

    private IntegerArrayOfArrays() {
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IntegerArrayOfArrays) {
            if (this == other) {
                return true;
            }
            IntegerArrayOfArrays that = (IntegerArrayOfArrays)other;
            if (!Objects.equals(this.getName(), that.getName())) {
                return false;
            }
            if (this.size() != that.size()) {
                return false;
            }
            for (long index = 0L; index < this.size(); ++index) {
                int[] thatSubArray;
                int[] thisSubArray = (int[])this.get(index);
                if (thisSubArray.length != (thatSubArray = (int[])that.get(index)).length) {
                    return false;
                }
                for (int subIndex = 0; subIndex < thisSubArray.length; ++subIndex) {
                    if (thisSubArray[subIndex] == thatSubArray[subIndex]) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ProtoAdapter getProtoAdapter() {
        return new ProtoIntegerArrayOfArraysAdapter();
    }

    @Override
    public int hashCode() {
        int initialPrime = 31;
        int hashSeed = 37;
        int nameHash = this.getName() == null ? 0 : this.getName().hashCode();
        int hash = 1147 + nameHash;
        hash = 37 * hash + Long.valueOf(this.size()).hashCode();
        for (long index = 0L; index < this.size(); ++index) {
            hash = 37 * hash + ((int[])this.get(index)).hashCode();
        }
        return hash;
    }

    @Override
    protected PrimitiveArray<int[]> getNewArray(int size) {
        return new PrimitiveIntegerArrayArray(size);
    }

    public static class PrimitiveIntegerArrayArray
    extends PrimitiveArray<int[]> {
        private static final long serialVersionUID = -4397674333836117261L;
        private final int[][] array = new int[this.size()][];

        public PrimitiveIntegerArrayArray(int size) {
            super(size);
        }

        @Override
        public int[] get(int index) {
            return this.array[index];
        }

        @Override
        public PrimitiveArray<int[]> getNewArray(int size) {
            return new PrimitiveIntegerArrayArray(size);
        }

        @Override
        public void set(int index, int[] item) {
            this.array[index] = item;
        }
    }
}

