/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.utilities.archive;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveException;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.archive.Archiver;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class ZipperCommand
extends Command {
    private static final Command.Switch<Path> INPUT_FILE_PARAMETER = new Command.Switch("input", "Input files to store in a zip file", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private static final Command.Switch<Path> OUTPUT_ZIP_FILE_PARAMETER = new Command.Switch("zip", "Zip file to store all of the data", x$0 -> Paths.get(x$0, new String[0]), Command.Optionality.REQUIRED);
    private static final Command.Flag COMPRESSION_FLAG = new Command.Flag("compress", "Enable compression of all files");

    public static void main(String ... args) {
        new ZipperCommand().runWithoutQuitting(args);
    }

    @Override
    protected int onRun(CommandMap command) {
        Path inputPath = this.prepareInput((Path)command.get(INPUT_FILE_PARAMETER));
        Path outputFile = this.prepareOutput((Path)command.get(OUTPUT_ZIP_FILE_PARAMETER));
        try {
            Archiver.createZipArchiver(outputFile).compress(inputPath);
        }
        catch (IOException | ArchiveException oops) {
            throw new CoreException("Error when archiving: {} -> {}", inputPath, outputFile, oops);
        }
        return 0;
    }

    @Override
    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(INPUT_FILE_PARAMETER, OUTPUT_ZIP_FILE_PARAMETER, COMPRESSION_FLAG);
    }

    private Path prepareInput(Path inputPath) {
        if (!Files.isReadable(inputPath)) {
            throw new CoreException("Can't read {} or it doesn't exist", inputPath);
        }
        return inputPath;
    }

    private Path prepareOutput(Path outputFile) {
        if (Files.exists(outputFile, new LinkOption[0])) {
            throw new CoreException("{} already exists. Aborting", outputFile);
        }
        try {
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        }
        catch (IOException oops) {
            throw new CoreException("Can't create parent directories for {}", outputFile, oops);
        }
        return outputFile;
    }
}

