/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.tags.names;

import java.util.Optional;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.Tag;
import org.openstreetmap.atlas.tags.annotations.TagKey;
import org.openstreetmap.atlas.tags.annotations.extraction.NonEmptyStringExtractor;

@Tag(value=Tag.Validation.NON_EMPTY_STRING, taginfo="http://taginfo.openstreetmap.org/keys/name#values", osm="http://wiki.openstreetmap.org/wiki/Key:name")
public interface NameTag {
    @TagKey(value=TagKey.KeyType.LOCALIZED)
    public static final String KEY = "name";

    public static Optional<String> getNameOf(Taggable taggable) {
        Optional<String> tagValue = taggable.getTag(KEY);
        if (tagValue.isPresent()) {
            return NonEmptyStringExtractor.validateAndExtract(tagValue.get());
        }
        return Optional.empty();
    }
}

